/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CancelArchivalOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelArchivalResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<CancelArchivalResponse.Builder, CancelArchivalResponse> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(CancelArchivalResponse::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tapeARN;

    private CancelArchivalResponse(BuilderImpl builder) {
        super(builder);
        this.tapeARN = builder.tapeARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelArchivalResponse)) {
            return false;
        }
        CancelArchivalResponse other = (CancelArchivalResponse) obj;
        return Objects.equals(tapeARN(), other.tapeARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelArchivalResponse").add("TapeARN", tapeARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TapeARN", TAPE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelArchivalResponse, T> g) {
        return obj -> g.apply((CancelArchivalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelArchivalResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of the virtual tape for which archiving was canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String tapeARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelArchivalResponse model) {
            super(model);
            tapeARN(model.tapeARN);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        @Override
        public CancelArchivalResponse build() {
            return new CancelArchivalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
