/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAvailabilityMonitorTestResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeAvailabilityMonitorTestResponse.Builder, DescribeAvailabilityMonitorTestResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeAvailabilityMonitorTestResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAvailabilityMonitorTestResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeAvailabilityMonitorTestResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            STATUS_FIELD, START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final String status;

    private final Instant startTime;

    private DescribeAvailabilityMonitorTestResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.status = builder.status;
        this.startTime = builder.startTime;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is
     * null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AvailabilityMonitorTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the high availability monitoring test. If a test hasn't been performed, the value of this
     *         field is null.
     * @see AvailabilityMonitorTestStatus
     */
    public final AvailabilityMonitorTestStatus status() {
        return AvailabilityMonitorTestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the high availability monitoring test. If a test hasn't been performed, the value of this field is
     * null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AvailabilityMonitorTestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the high availability monitoring test. If a test hasn't been performed, the value of this
     *         field is null.
     * @see AvailabilityMonitorTestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the high availability monitoring test was started. If a test hasn't been performed, the value of this
     * field is null.
     * </p>
     * 
     * @return The time the high availability monitoring test was started. If a test hasn't been performed, the value of
     *         this field is null.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityMonitorTestResponse)) {
            return false;
        }
        DescribeAvailabilityMonitorTestResponse other = (DescribeAvailabilityMonitorTestResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAvailabilityMonitorTestResponse").add("GatewayARN", gatewayARN())
                .add("Status", statusAsString()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAvailabilityMonitorTestResponse, T> g) {
        return obj -> g.apply((DescribeAvailabilityMonitorTestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAvailabilityMonitorTestResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The status of the high availability monitoring test. If a test hasn't been performed, the value of this field
         * is null.
         * </p>
         * 
         * @param status
         *        The status of the high availability monitoring test. If a test hasn't been performed, the value of
         *        this field is null.
         * @see AvailabilityMonitorTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityMonitorTestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the high availability monitoring test. If a test hasn't been performed, the value of this field
         * is null.
         * </p>
         * 
         * @param status
         *        The status of the high availability monitoring test. If a test hasn't been performed, the value of
         *        this field is null.
         * @see AvailabilityMonitorTestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityMonitorTestStatus
         */
        Builder status(AvailabilityMonitorTestStatus status);

        /**
         * <p>
         * The time the high availability monitoring test was started. If a test hasn't been performed, the value of
         * this field is null.
         * </p>
         * 
         * @param startTime
         *        The time the high availability monitoring test was started. If a test hasn't been performed, the value
         *        of this field is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private String status;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityMonitorTestResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            status(model.status);
            startTime(model.startTime);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AvailabilityMonitorTestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public DescribeAvailabilityMonitorTestResponse build() {
            return new DescribeAvailabilityMonitorTestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
