/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the Amazon Resource Name (ARN) of the gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBandwidthRateLimitRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeBandwidthRateLimitRequest.Builder, DescribeBandwidthRateLimitRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeBandwidthRateLimitRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private DescribeBandwidthRateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBandwidthRateLimitRequest)) {
            return false;
        }
        DescribeBandwidthRateLimitRequest other = (DescribeBandwidthRateLimitRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBandwidthRateLimitRequest").add("GatewayARN", gatewayARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBandwidthRateLimitRequest, T> g) {
        return obj -> g.apply((DescribeBandwidthRateLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBandwidthRateLimitRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBandwidthRateLimitRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBandwidthRateLimitRequest build() {
            return new DescribeBandwidthRateLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
