/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeVTLDevicesOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVtlDevicesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeVtlDevicesResponse.Builder, DescribeVtlDevicesResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeVtlDevicesResponse::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<VTLDevice>> VTL_DEVICES_FIELD = SdkField
            .<List<VTLDevice>> builder(MarshallingType.LIST)
            .memberName("VTLDevices")
            .getter(getter(DescribeVtlDevicesResponse::vtlDevices))
            .setter(setter(Builder::vtlDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VTLDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VTLDevice> builder(MarshallingType.SDK_POJO)
                                            .constructor(VTLDevice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeVtlDevicesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            VTL_DEVICES_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final List<VTLDevice> vtlDevices;

    private final String marker;

    private DescribeVtlDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.vtlDevices = builder.vtlDevices;
        this.marker = builder.marker;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the VTLDevices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVtlDevices() {
        return vtlDevices != null && !(vtlDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVtlDevices} method.
     * </p>
     * 
     * @return An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
     */
    public final List<VTLDevice> vtlDevices() {
        return vtlDevices;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which the VTL devices that were fetched for description ended.
     * Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no more VTL
     * devices to describe, this field does not appear in the response.
     * </p>
     * 
     * @return An opaque string that indicates the position at which the VTL devices that were fetched for description
     *         ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are
     *         no more VTL devices to describe, this field does not appear in the response.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasVtlDevices() ? vtlDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVtlDevicesResponse)) {
            return false;
        }
        DescribeVtlDevicesResponse other = (DescribeVtlDevicesResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && hasVtlDevices() == other.hasVtlDevices()
                && Objects.equals(vtlDevices(), other.vtlDevices()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVtlDevicesResponse").add("GatewayARN", gatewayARN())
                .add("VTLDevices", hasVtlDevices() ? vtlDevices() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "VTLDevices":
            return Optional.ofNullable(clazz.cast(vtlDevices()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("VTLDevices", VTL_DEVICES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVtlDevicesResponse, T> g) {
        return obj -> g.apply((DescribeVtlDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVtlDevicesResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * 
         * @param vtlDevices
         *        An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevices(Collection<VTLDevice> vtlDevices);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * 
         * @param vtlDevices
         *        An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vtlDevices(VTLDevice... vtlDevices);

        /**
         * <p>
         * An array of VTL device objects composed of the Amazon Resource Name (ARN) of the VTL devices.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.VTLDevice.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.storagegateway.model.VTLDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.VTLDevice.Builder#build()} is called immediately
         * and its result is passed to {@link #vtlDevices(List<VTLDevice>)}.
         * 
         * @param vtlDevices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.VTLDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vtlDevices(java.util.Collection<VTLDevice>)
         */
        Builder vtlDevices(Consumer<VTLDevice.Builder>... vtlDevices);

        /**
         * <p>
         * An opaque string that indicates the position at which the VTL devices that were fetched for description
         * ended. Use the marker in your next request to fetch the next set of VTL devices in the list. If there are no
         * more VTL devices to describe, this field does not appear in the response.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which the VTL devices that were fetched for
         *        description ended. Use the marker in your next request to fetch the next set of VTL devices in the
         *        list. If there are no more VTL devices to describe, this field does not appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<VTLDevice> vtlDevices = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVtlDevicesResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            vtlDevices(model.vtlDevices);
            marker(model.marker);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final List<VTLDevice.Builder> getVtlDevices() {
            List<VTLDevice.Builder> result = VTLDevicesCopier.copyToBuilder(this.vtlDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVtlDevices(Collection<VTLDevice.BuilderImpl> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copyFromBuilder(vtlDevices);
        }

        @Override
        public final Builder vtlDevices(Collection<VTLDevice> vtlDevices) {
            this.vtlDevices = VTLDevicesCopier.copy(vtlDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(VTLDevice... vtlDevices) {
            vtlDevices(Arrays.asList(vtlDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vtlDevices(Consumer<VTLDevice.Builder>... vtlDevices) {
            vtlDevices(Stream.of(vtlDevices).map(c -> VTLDevice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeVtlDevicesResponse build() {
            return new DescribeVtlDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
