/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a virtual tape that is archived in the virtual tape shelf (VTS).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TapeArchive implements SdkPojo, Serializable, ToCopyableBuilder<TapeArchive.Builder, TapeArchive> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeARN").getter(getter(TapeArchive::tapeARN)).setter(setter(Builder::tapeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeBarcode").getter(getter(TapeArchive::tapeBarcode)).setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Instant> TAPE_CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TapeCreatedDate").getter(getter(TapeArchive::tapeCreatedDate)).setter(setter(Builder::tapeCreatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeCreatedDate").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeSizeInBytes").getter(getter(TapeArchive::tapeSizeInBytes)).setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(TapeArchive::completionTime)).setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> RETRIEVED_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrievedTo").getter(getter(TapeArchive::retrievedTo)).setter(setter(Builder::retrievedTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrievedTo").build()).build();

    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeStatus").getter(getter(TapeArchive::tapeStatus)).setter(setter(Builder::tapeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()).build();

    private static final SdkField<Long> TAPE_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeUsedInBytes").getter(getter(TapeArchive::tapeUsedInBytes)).setter(setter(Builder::tapeUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeUsedInBytes").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(TapeArchive::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(TapeArchive::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Boolean> WORM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Worm")
            .getter(getter(TapeArchive::worm)).setter(setter(Builder::worm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Worm").build()).build();

    private static final SdkField<Instant> RETENTION_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetentionStartDate").getter(getter(TapeArchive::retentionStartDate))
            .setter(setter(Builder::retentionStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionStartDate").build())
            .build();

    private static final SdkField<Instant> POOL_ENTRY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PoolEntryDate").getter(getter(TapeArchive::poolEntryDate)).setter(setter(Builder::poolEntryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolEntryDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD,
            TAPE_BARCODE_FIELD, TAPE_CREATED_DATE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, COMPLETION_TIME_FIELD, RETRIEVED_TO_FIELD,
            TAPE_STATUS_FIELD, TAPE_USED_IN_BYTES_FIELD, KMS_KEY_FIELD, POOL_ID_FIELD, WORM_FIELD, RETENTION_START_DATE_FIELD,
            POOL_ENTRY_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tapeARN;

    private final String tapeBarcode;

    private final Instant tapeCreatedDate;

    private final Long tapeSizeInBytes;

    private final Instant completionTime;

    private final String retrievedTo;

    private final String tapeStatus;

    private final Long tapeUsedInBytes;

    private final String kmsKey;

    private final String poolId;

    private final Boolean worm;

    private final Instant retentionStartDate;

    private final Instant poolEntryDate;

    private TapeArchive(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeCreatedDate = builder.tapeCreatedDate;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.completionTime = builder.completionTime;
        this.retrievedTo = builder.retrievedTo;
        this.tapeStatus = builder.tapeStatus;
        this.tapeUsedInBytes = builder.tapeUsedInBytes;
        this.kmsKey = builder.kmsKey;
        this.poolId = builder.poolId;
        this.worm = builder.worm;
        this.retentionStartDate = builder.retentionStartDate;
        this.poolEntryDate = builder.poolEntryDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an archived virtual tape.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an archived virtual tape.
     */
    public final String tapeARN() {
        return tapeARN;
    }

    /**
     * <p>
     * The barcode that identifies the archived virtual tape.
     * </p>
     * 
     * @return The barcode that identifies the archived virtual tape.
     */
    public final String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * The date the virtual tape was created.
     * </p>
     * 
     * @return The date the virtual tape was created.
     */
    public final Instant tapeCreatedDate() {
        return tapeCreatedDate;
    }

    /**
     * <p>
     * The size, in bytes, of the archived virtual tape.
     * </p>
     * 
     * @return The size, in bytes, of the archived virtual tape.
     */
    public final Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The time that the archiving of the virtual tape was completed.
     * </p>
     * <p>
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     * </p>
     * 
     * @return The time that the archiving of the virtual tape was completed.</p>
     *         <p>
     *         The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.
     * </p>
     * <p>
     * The virtual tape is retrieved from the virtual tape shelf (VTS).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.</p>
     *         <p>
     *         The virtual tape is retrieved from the virtual tape shelf (VTS).
     */
    public final String retrievedTo() {
        return retrievedTo;
    }

    /**
     * <p>
     * The current state of the archived virtual tape.
     * </p>
     * 
     * @return The current state of the archived virtual tape.
     */
    public final String tapeStatus() {
        return tapeStatus;
    }

    /**
     * <p>
     * The size, in bytes, of data stored on the virtual tape.
     * </p>
     * <note>
     * <p>
     * This value is not available for tapes created prior to May 13, 2015.
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of data stored on the virtual tape.</p> <note>
     *         <p>
     *         This value is not available for tapes created prior to May 13, 2015.
     *         </p>
     */
    public final Long tapeUsedInBytes() {
        return tapeUsedInBytes;
    }

    /**
     * Returns the value of the KMSKey property for this object.
     * 
     * @return The value of the KMSKey property for this object.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3 storage class
     * that is associated with the pool.
     * </p>
     * 
     * @return The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3
     *         storage class that is associated with the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Set to <code>true</code> if the archived tape is stored as write-once-read-many (WORM).
     * </p>
     * 
     * @return Set to <code>true</code> if the archived tape is stored as write-once-read-many (WORM).
     */
    public final Boolean worm() {
        return worm;
    }

    /**
     * <p>
     * If the archived tape is subject to tape retention lock, the date that the archived tape started being retained.
     * </p>
     * 
     * @return If the archived tape is subject to tape retention lock, the date that the archived tape started being
     *         retained.
     */
    public final Instant retentionStartDate() {
        return retentionStartDate;
    }

    /**
     * <p>
     * The time that the tape entered the custom tape pool.
     * </p>
     * <p>
     * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     * </p>
     * 
     * @return The time that the tape entered the custom tape pool.</p>
     *         <p>
     *         The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
     */
    public final Instant poolEntryDate() {
        return poolEntryDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(tapeCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(retrievedTo());
        hashCode = 31 * hashCode + Objects.hashCode(tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(tapeUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(worm());
        hashCode = 31 * hashCode + Objects.hashCode(retentionStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(poolEntryDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeArchive)) {
            return false;
        }
        TapeArchive other = (TapeArchive) obj;
        return Objects.equals(tapeARN(), other.tapeARN()) && Objects.equals(tapeBarcode(), other.tapeBarcode())
                && Objects.equals(tapeCreatedDate(), other.tapeCreatedDate())
                && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(retrievedTo(), other.retrievedTo())
                && Objects.equals(tapeStatus(), other.tapeStatus()) && Objects.equals(tapeUsedInBytes(), other.tapeUsedInBytes())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(worm(), other.worm()) && Objects.equals(retentionStartDate(), other.retentionStartDate())
                && Objects.equals(poolEntryDate(), other.poolEntryDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TapeArchive").add("TapeARN", tapeARN()).add("TapeBarcode", tapeBarcode())
                .add("TapeCreatedDate", tapeCreatedDate()).add("TapeSizeInBytes", tapeSizeInBytes())
                .add("CompletionTime", completionTime()).add("RetrievedTo", retrievedTo()).add("TapeStatus", tapeStatus())
                .add("TapeUsedInBytes", tapeUsedInBytes()).add("KMSKey", kmsKey()).add("PoolId", poolId()).add("Worm", worm())
                .add("RetentionStartDate", retentionStartDate()).add("PoolEntryDate", poolEntryDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARN":
            return Optional.ofNullable(clazz.cast(tapeARN()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "TapeCreatedDate":
            return Optional.ofNullable(clazz.cast(tapeCreatedDate()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "RetrievedTo":
            return Optional.ofNullable(clazz.cast(retrievedTo()));
        case "TapeStatus":
            return Optional.ofNullable(clazz.cast(tapeStatus()));
        case "TapeUsedInBytes":
            return Optional.ofNullable(clazz.cast(tapeUsedInBytes()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Worm":
            return Optional.ofNullable(clazz.cast(worm()));
        case "RetentionStartDate":
            return Optional.ofNullable(clazz.cast(retentionStartDate()));
        case "PoolEntryDate":
            return Optional.ofNullable(clazz.cast(poolEntryDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TapeARN", TAPE_ARN_FIELD);
        map.put("TapeBarcode", TAPE_BARCODE_FIELD);
        map.put("TapeCreatedDate", TAPE_CREATED_DATE_FIELD);
        map.put("TapeSizeInBytes", TAPE_SIZE_IN_BYTES_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("RetrievedTo", RETRIEVED_TO_FIELD);
        map.put("TapeStatus", TAPE_STATUS_FIELD);
        map.put("TapeUsedInBytes", TAPE_USED_IN_BYTES_FIELD);
        map.put("KMSKey", KMS_KEY_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Worm", WORM_FIELD);
        map.put("RetentionStartDate", RETENTION_START_DATE_FIELD);
        map.put("PoolEntryDate", POOL_ENTRY_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TapeArchive, T> g) {
        return obj -> g.apply((TapeArchive) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TapeArchive> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an archived virtual tape.
         * </p>
         * 
         * @param tapeARN
         *        The Amazon Resource Name (ARN) of an archived virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARN(String tapeARN);

        /**
         * <p>
         * The barcode that identifies the archived virtual tape.
         * </p>
         * 
         * @param tapeBarcode
         *        The barcode that identifies the archived virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * The date the virtual tape was created.
         * </p>
         * 
         * @param tapeCreatedDate
         *        The date the virtual tape was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeCreatedDate(Instant tapeCreatedDate);

        /**
         * <p>
         * The size, in bytes, of the archived virtual tape.
         * </p>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the archived virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The time that the archiving of the virtual tape was completed.
         * </p>
         * <p>
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * </p>
         * 
         * @param completionTime
         *        The time that the archiving of the virtual tape was completed.</p>
         *        <p>
         *        The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.
         * </p>
         * <p>
         * The virtual tape is retrieved from the virtual tape shelf (VTS).
         * </p>
         * 
         * @param retrievedTo
         *        The Amazon Resource Name (ARN) of the tape gateway that the virtual tape is being retrieved to.</p>
         *        <p>
         *        The virtual tape is retrieved from the virtual tape shelf (VTS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievedTo(String retrievedTo);

        /**
         * <p>
         * The current state of the archived virtual tape.
         * </p>
         * 
         * @param tapeStatus
         *        The current state of the archived virtual tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeStatus(String tapeStatus);

        /**
         * <p>
         * The size, in bytes, of data stored on the virtual tape.
         * </p>
         * <note>
         * <p>
         * This value is not available for tapes created prior to May 13, 2015.
         * </p>
         * </note>
         * 
         * @param tapeUsedInBytes
         *        The size, in bytes, of data stored on the virtual tape.</p> <note>
         *        <p>
         *        This value is not available for tapes created prior to May 13, 2015.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeUsedInBytes(Long tapeUsedInBytes);

        /**
         * Sets the value of the KMSKey property for this object.
         *
         * @param kmsKey
         *        The new value for the KMSKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3 storage
         * class that is associated with the pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that was used to archive the tape. The tapes in this pool are archived in the S3
         *        storage class that is associated with the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Set to <code>true</code> if the archived tape is stored as write-once-read-many (WORM).
         * </p>
         * 
         * @param worm
         *        Set to <code>true</code> if the archived tape is stored as write-once-read-many (WORM).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worm(Boolean worm);

        /**
         * <p>
         * If the archived tape is subject to tape retention lock, the date that the archived tape started being
         * retained.
         * </p>
         * 
         * @param retentionStartDate
         *        If the archived tape is subject to tape retention lock, the date that the archived tape started being
         *        retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionStartDate(Instant retentionStartDate);

        /**
         * <p>
         * The time that the tape entered the custom tape pool.
         * </p>
         * <p>
         * The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * </p>
         * 
         * @param poolEntryDate
         *        The time that the tape entered the custom tape pool.</p>
         *        <p>
         *        The default timestamp format is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z' format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolEntryDate(Instant poolEntryDate);
    }

    static final class BuilderImpl implements Builder {
        private String tapeARN;

        private String tapeBarcode;

        private Instant tapeCreatedDate;

        private Long tapeSizeInBytes;

        private Instant completionTime;

        private String retrievedTo;

        private String tapeStatus;

        private Long tapeUsedInBytes;

        private String kmsKey;

        private String poolId;

        private Boolean worm;

        private Instant retentionStartDate;

        private Instant poolEntryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeArchive model) {
            tapeARN(model.tapeARN);
            tapeBarcode(model.tapeBarcode);
            tapeCreatedDate(model.tapeCreatedDate);
            tapeSizeInBytes(model.tapeSizeInBytes);
            completionTime(model.completionTime);
            retrievedTo(model.retrievedTo);
            tapeStatus(model.tapeStatus);
            tapeUsedInBytes(model.tapeUsedInBytes);
            kmsKey(model.kmsKey);
            poolId(model.poolId);
            worm(model.worm);
            retentionStartDate(model.retentionStartDate);
            poolEntryDate(model.poolEntryDate);
        }

        public final String getTapeARN() {
            return tapeARN;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final Instant getTapeCreatedDate() {
            return tapeCreatedDate;
        }

        public final void setTapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
        }

        @Override
        public final Builder tapeCreatedDate(Instant tapeCreatedDate) {
            this.tapeCreatedDate = tapeCreatedDate;
            return this;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getRetrievedTo() {
            return retrievedTo;
        }

        public final void setRetrievedTo(String retrievedTo) {
            this.retrievedTo = retrievedTo;
        }

        @Override
        public final Builder retrievedTo(String retrievedTo) {
            this.retrievedTo = retrievedTo;
            return this;
        }

        public final String getTapeStatus() {
            return tapeStatus;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final Long getTapeUsedInBytes() {
            return tapeUsedInBytes;
        }

        public final void setTapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
        }

        @Override
        public final Builder tapeUsedInBytes(Long tapeUsedInBytes) {
            this.tapeUsedInBytes = tapeUsedInBytes;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Boolean getWorm() {
            return worm;
        }

        public final void setWorm(Boolean worm) {
            this.worm = worm;
        }

        @Override
        public final Builder worm(Boolean worm) {
            this.worm = worm;
            return this;
        }

        public final Instant getRetentionStartDate() {
            return retentionStartDate;
        }

        public final void setRetentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
        }

        @Override
        public final Builder retentionStartDate(Instant retentionStartDate) {
            this.retentionStartDate = retentionStartDate;
            return this;
        }

        public final Instant getPoolEntryDate() {
            return poolEntryDate;
        }

        public final void setPoolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
        }

        @Override
        public final Builder poolEntryDate(Instant poolEntryDate) {
            this.poolEntryDate = poolEntryDate;
            return this;
        }

        @Override
        public TapeArchive build() {
            return new TapeArchive(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
