/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$SoftwareUpdatePreferences</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$DayOfMonth</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$DayOfWeek</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$HourOfDay</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateMaintenanceStartTimeInput$MinuteOfHour</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMaintenanceStartTimeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateMaintenanceStartTimeRequest.Builder, UpdateMaintenanceStartTimeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(UpdateMaintenanceStartTimeRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourOfDay").getter(getter(UpdateMaintenanceStartTimeRequest::hourOfDay))
            .setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinuteOfHour").getter(getter(UpdateMaintenanceStartTimeRequest::minuteOfHour))
            .setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfWeek").getter(getter(UpdateMaintenanceStartTimeRequest::dayOfWeek))
            .setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(UpdateMaintenanceStartTimeRequest::dayOfMonth))
            .setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<SoftwareUpdatePreferences> SOFTWARE_UPDATE_PREFERENCES_FIELD = SdkField
            .<SoftwareUpdatePreferences> builder(MarshallingType.SDK_POJO).memberName("SoftwareUpdatePreferences")
            .getter(getter(UpdateMaintenanceStartTimeRequest::softwareUpdatePreferences))
            .setter(setter(Builder::softwareUpdatePreferences)).constructor(SoftwareUpdatePreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdatePreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD, DAY_OF_WEEK_FIELD, DAY_OF_MONTH_FIELD, SOFTWARE_UPDATE_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private final Integer dayOfWeek;

    private final Integer dayOfMonth;

    private final SoftwareUpdatePreferences softwareUpdatePreferences;

    private UpdateMaintenanceStartTimeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
        this.dayOfWeek = builder.dayOfWeek;
        this.dayOfMonth = builder.dayOfMonth;
        this.softwareUpdatePreferences = builder.softwareUpdatePreferences;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to
     * 23). The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
     *         (00 to 23). The hour of the day is in the time zone of the gateway.
     */
    public final Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (00 to
     * 59). The minute of the hour is in the time zone of the gateway.
     * </p>
     * 
     * @return The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
     *         minute (00 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public final Integer minuteOfHour() {
        return minuteOfHour;
    }

    /**
     * <p>
     * The day of the week component of the maintenance start time week represented as an ordinal number from 0 to 6,
     * where 0 represents Sunday and 6 represents Saturday.
     * </p>
     * 
     * @return The day of the week component of the maintenance start time week represented as an ordinal number from 0
     *         to 6, where 0 represents Sunday and 6 represents Saturday.
     */
    public final Integer dayOfWeek() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where
     * 1 represents the first day of the month. It is not possible to set the maintenance schedule to start on days 29
     * through 31.
     * </p>
     * 
     * @return The day of the month component of the maintenance start time represented as an ordinal number from 1 to
     *         28, where 1 represents the first day of the month. It is not possible to set the maintenance schedule to
     *         start on days 29 through 31.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * A set of variables indicating the software update preferences for the gateway.
     * </p>
     * <p>
     * Includes <code>AutomaticUpdatePolicy</code> field with the following inputs:
     * </p>
     * <p>
     * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     * </p>
     * <p>
     * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
     * receive emergency version updates on rare occasions if necessary to remedy highly critical security or durability
     * issues. You will be notified before an emergency version update is applied. These updates are applied during your
     * gateway's scheduled maintenance window.
     * </p>
     * 
     * @return A set of variables indicating the software update preferences for the gateway.</p>
     *         <p>
     *         Includes <code>AutomaticUpdatePolicy</code> field with the following inputs:
     *         </p>
     *         <p>
     *         <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
     *         </p>
     *         <p>
     *         <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
     *         still receive emergency version updates on rare occasions if necessary to remedy highly critical security
     *         or durability issues. You will be notified before an emergency version update is applied. These updates
     *         are applied during your gateway's scheduled maintenance window.
     */
    public final SoftwareUpdatePreferences softwareUpdatePreferences() {
        return softwareUpdatePreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(softwareUpdatePreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceStartTimeRequest)) {
            return false;
        }
        UpdateMaintenanceStartTimeRequest other = (UpdateMaintenanceStartTimeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(hourOfDay(), other.hourOfDay())
                && Objects.equals(minuteOfHour(), other.minuteOfHour()) && Objects.equals(dayOfWeek(), other.dayOfWeek())
                && Objects.equals(dayOfMonth(), other.dayOfMonth())
                && Objects.equals(softwareUpdatePreferences(), other.softwareUpdatePreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMaintenanceStartTimeRequest").add("GatewayARN", gatewayARN())
                .add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).add("DayOfWeek", dayOfWeek())
                .add("DayOfMonth", dayOfMonth()).add("SoftwareUpdatePreferences", softwareUpdatePreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "SoftwareUpdatePreferences":
            return Optional.ofNullable(clazz.cast(softwareUpdatePreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("HourOfDay", HOUR_OF_DAY_FIELD);
        map.put("MinuteOfHour", MINUTE_OF_HOUR_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("SoftwareUpdatePreferences", SOFTWARE_UPDATE_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceStartTimeRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceStartTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMaintenanceStartTimeRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (00 to
         * 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param hourOfDay
         *        The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
         *        (00 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute
         * (00 to 59). The minute of the hour is in the time zone of the gateway.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
         *        minute (00 to 59). The minute of the hour is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);

        /**
         * <p>
         * The day of the week component of the maintenance start time week represented as an ordinal number from 0 to
         * 6, where 0 represents Sunday and 6 represents Saturday.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week component of the maintenance start time week represented as an ordinal number from
         *        0 to 6, where 0 represents Sunday and 6 represents Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(Integer dayOfWeek);

        /**
         * <p>
         * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28,
         * where 1 represents the first day of the month. It is not possible to set the maintenance schedule to start on
         * days 29 through 31.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month component of the maintenance start time represented as an ordinal number from 1
         *        to 28, where 1 represents the first day of the month. It is not possible to set the maintenance
         *        schedule to start on days 29 through 31.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * A set of variables indicating the software update preferences for the gateway.
         * </p>
         * <p>
         * Includes <code>AutomaticUpdatePolicy</code> field with the following inputs:
         * </p>
         * <p>
         * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         * </p>
         * <p>
         * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
         * receive emergency version updates on rare occasions if necessary to remedy highly critical security or
         * durability issues. You will be notified before an emergency version update is applied. These updates are
         * applied during your gateway's scheduled maintenance window.
         * </p>
         * 
         * @param softwareUpdatePreferences
         *        A set of variables indicating the software update preferences for the gateway.</p>
         *        <p>
         *        Includes <code>AutomaticUpdatePolicy</code> field with the following inputs:
         *        </p>
         *        <p>
         *        <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         *        </p>
         *        <p>
         *        <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will
         *        still receive emergency version updates on rare occasions if necessary to remedy highly critical
         *        security or durability issues. You will be notified before an emergency version update is applied.
         *        These updates are applied during your gateway's scheduled maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareUpdatePreferences(SoftwareUpdatePreferences softwareUpdatePreferences);

        /**
         * <p>
         * A set of variables indicating the software update preferences for the gateway.
         * </p>
         * <p>
         * Includes <code>AutomaticUpdatePolicy</code> field with the following inputs:
         * </p>
         * <p>
         * <code>ALL_VERSIONS</code> - Enables regular gateway maintenance updates.
         * </p>
         * <p>
         * <code>EMERGENCY_VERSIONS_ONLY</code> - Disables regular gateway maintenance updates. The gateway will still
         * receive emergency version updates on rare occasions if necessary to remedy highly critical security or
         * durability issues. You will be notified before an emergency version update is applied. These updates are
         * applied during your gateway's scheduled maintenance window.
         * </p>
         * This is a convenience method that creates an instance of the {@link SoftwareUpdatePreferences.Builder}
         * avoiding the need to create one manually via {@link SoftwareUpdatePreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SoftwareUpdatePreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #softwareUpdatePreferences(SoftwareUpdatePreferences)}.
         * 
         * @param softwareUpdatePreferences
         *        a consumer that will call methods on {@link SoftwareUpdatePreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareUpdatePreferences(SoftwareUpdatePreferences)
         */
        default Builder softwareUpdatePreferences(Consumer<SoftwareUpdatePreferences.Builder> softwareUpdatePreferences) {
            return softwareUpdatePreferences(SoftwareUpdatePreferences.builder().applyMutation(softwareUpdatePreferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Integer hourOfDay;

        private Integer minuteOfHour;

        private Integer dayOfWeek;

        private Integer dayOfMonth;

        private SoftwareUpdatePreferences softwareUpdatePreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceStartTimeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
            dayOfWeek(model.dayOfWeek);
            dayOfMonth(model.dayOfMonth);
            softwareUpdatePreferences(model.softwareUpdatePreferences);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        public final Integer getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final SoftwareUpdatePreferences.Builder getSoftwareUpdatePreferences() {
            return softwareUpdatePreferences != null ? softwareUpdatePreferences.toBuilder() : null;
        }

        public final void setSoftwareUpdatePreferences(SoftwareUpdatePreferences.BuilderImpl softwareUpdatePreferences) {
            this.softwareUpdatePreferences = softwareUpdatePreferences != null ? softwareUpdatePreferences.build() : null;
        }

        @Override
        public final Builder softwareUpdatePreferences(SoftwareUpdatePreferences softwareUpdatePreferences) {
            this.softwareUpdatePreferences = softwareUpdatePreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceStartTimeRequest build() {
            return new UpdateMaintenanceStartTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
