/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCachediScsiVolumeRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, CreateCachediScsiVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::gatewayARN)).setter(CreateCachediScsiVolumeRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VolumeSizeInBytes").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::volumeSizeInBytes)).setter(CreateCachediScsiVolumeRequest.setter(Builder::volumeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::snapshotId)).setter(CreateCachediScsiVolumeRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetName").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::targetName)).setter(CreateCachediScsiVolumeRequest.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()}).build();
    private static final SdkField<String> SOURCE_VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVolumeARN").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::sourceVolumeARN)).setter(CreateCachediScsiVolumeRequest.setter(Builder::sourceVolumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolumeARN").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::networkInterfaceId)).setter(CreateCachediScsiVolumeRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::clientToken)).setter(CreateCachediScsiVolumeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KMSEncrypted").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::kmsEncrypted)).setter(CreateCachediScsiVolumeRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKey").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::kmsKey)).setter(CreateCachediScsiVolumeRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCachediScsiVolumeRequest.getter(CreateCachediScsiVolumeRequest::tags)).setter(CreateCachediScsiVolumeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, VOLUME_SIZE_IN_BYTES_FIELD, SNAPSHOT_ID_FIELD, TARGET_NAME_FIELD, SOURCE_VOLUME_ARN_FIELD, NETWORK_INTERFACE_ID_FIELD, CLIENT_TOKEN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCachediScsiVolumeRequest.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final Long volumeSizeInBytes;
    private final String snapshotId;
    private final String targetName;
    private final String sourceVolumeARN;
    private final String networkInterfaceId;
    private final String clientToken;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final List<Tag> tags;

    private CreateCachediScsiVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.snapshotId = builder.snapshotId;
        this.targetName = builder.targetName;
        this.sourceVolumeARN = builder.sourceVolumeARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.clientToken = builder.clientToken;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.tags = builder.tags;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final Long volumeSizeInBytes() {
        return this.volumeSizeInBytes;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final String targetName() {
        return this.targetName;
    }

    public final String sourceVolumeARN() {
        return this.sourceVolumeARN;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVolumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachediScsiVolumeRequest)) {
            return false;
        }
        CreateCachediScsiVolumeRequest other = (CreateCachediScsiVolumeRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.volumeSizeInBytes(), other.volumeSizeInBytes()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.targetName(), other.targetName()) && Objects.equals(this.sourceVolumeARN(), other.sourceVolumeARN()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCachediScsiVolumeRequest").add("GatewayARN", (Object)this.gatewayARN()).add("VolumeSizeInBytes", (Object)this.volumeSizeInBytes()).add("SnapshotId", (Object)this.snapshotId()).add("TargetName", (Object)this.targetName()).add("SourceVolumeARN", (Object)this.sourceVolumeARN()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("ClientToken", (Object)this.clientToken()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "VolumeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInBytes()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "TargetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
            case "SourceVolumeARN": {
                return Optional.ofNullable(clazz.cast(this.sourceVolumeARN()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("VolumeSizeInBytes", VOLUME_SIZE_IN_BYTES_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("TargetName", TARGET_NAME_FIELD);
        map.put("SourceVolumeARN", SOURCE_VOLUME_ARN_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("KMSEncrypted", KMS_ENCRYPTED_FIELD);
        map.put("KMSKey", KMS_KEY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCachediScsiVolumeRequest, T> g) {
        return obj -> g.apply((CreateCachediScsiVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private Long volumeSizeInBytes;
        private String snapshotId;
        private String targetName;
        private String sourceVolumeARN;
        private String networkInterfaceId;
        private String clientToken;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachediScsiVolumeRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.volumeSizeInBytes(model.volumeSizeInBytes);
            this.snapshotId(model.snapshotId);
            this.targetName(model.targetName);
            this.sourceVolumeARN(model.sourceVolumeARN);
            this.networkInterfaceId(model.networkInterfaceId);
            this.clientToken(model.clientToken);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.tags(model.tags);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Long getVolumeSizeInBytes() {
            return this.volumeSizeInBytes;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final String getSourceVolumeARN() {
            return this.sourceVolumeARN;
        }

        public final void setSourceVolumeARN(String sourceVolumeARN) {
            this.sourceVolumeARN = sourceVolumeARN;
        }

        @Override
        public final Builder sourceVolumeARN(String sourceVolumeARN) {
            this.sourceVolumeARN = sourceVolumeARN;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCachediScsiVolumeRequest build() {
            return new CreateCachediScsiVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCachediScsiVolumeRequest> {
        public Builder gatewayARN(String var1);

        public Builder volumeSizeInBytes(Long var1);

        public Builder snapshotId(String var1);

        public Builder targetName(String var1);

        public Builder sourceVolumeARN(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder clientToken(String var1);

        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

