/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeArchive;
import software.amazon.awssdk.services.storagegateway.model.TapeArchivesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapeArchivesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeTapeArchivesResponse> {
    private static final SdkField<List<TapeArchive>> TAPE_ARCHIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TapeArchives").getter(DescribeTapeArchivesResponse.getter(DescribeTapeArchivesResponse::tapeArchives)).setter(DescribeTapeArchivesResponse.setter(Builder::tapeArchives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeArchives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TapeArchive::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTapeArchivesResponse.getter(DescribeTapeArchivesResponse::marker)).setter(DescribeTapeArchivesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARCHIVES_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTapeArchivesResponse.memberNameToFieldInitializer();
    private final List<TapeArchive> tapeArchives;
    private final String marker;

    private DescribeTapeArchivesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeArchives = builder.tapeArchives;
        this.marker = builder.marker;
    }

    public final boolean hasTapeArchives() {
        return this.tapeArchives != null && !(this.tapeArchives instanceof SdkAutoConstructList);
    }

    public final List<TapeArchive> tapeArchives() {
        return this.tapeArchives;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTapeArchives() ? this.tapeArchives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeArchivesResponse)) {
            return false;
        }
        DescribeTapeArchivesResponse other = (DescribeTapeArchivesResponse)((Object)obj);
        return this.hasTapeArchives() == other.hasTapeArchives() && Objects.equals(this.tapeArchives(), other.tapeArchives()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTapeArchivesResponse").add("TapeArchives", this.hasTapeArchives() ? this.tapeArchives() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeArchives": {
                return Optional.ofNullable(clazz.cast(this.tapeArchives()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TapeArchives", TAPE_ARCHIVES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeArchivesResponse, T> g) {
        return obj -> g.apply((DescribeTapeArchivesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<TapeArchive> tapeArchives = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeArchivesResponse model) {
            super(model);
            this.tapeArchives(model.tapeArchives);
            this.marker(model.marker);
        }

        public final List<TapeArchive.Builder> getTapeArchives() {
            List<TapeArchive.Builder> result = TapeArchivesCopier.copyToBuilder(this.tapeArchives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTapeArchives(Collection<TapeArchive.BuilderImpl> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copyFromBuilder(tapeArchives);
        }

        @Override
        public final Builder tapeArchives(Collection<TapeArchive> tapeArchives) {
            this.tapeArchives = TapeArchivesCopier.copy(tapeArchives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeArchives(TapeArchive ... tapeArchives) {
            this.tapeArchives(Arrays.asList(tapeArchives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeArchives(Consumer<TapeArchive.Builder> ... tapeArchives) {
            this.tapeArchives(Stream.of(tapeArchives).map(c -> (TapeArchive)((TapeArchive.Builder)TapeArchive.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeTapeArchivesResponse build() {
            return new DescribeTapeArchivesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapeArchivesResponse> {
        public Builder tapeArchives(Collection<TapeArchive> var1);

        public Builder tapeArchives(TapeArchive ... var1);

        public Builder tapeArchives(Consumer<TapeArchive.Builder> ... var1);

        public Builder marker(String var1);
    }
}

