/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.IpAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointNetworkConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointNetworkConfiguration> {
    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpAddresses").getter(EndpointNetworkConfiguration.getter(EndpointNetworkConfiguration::ipAddresses)).setter(EndpointNetworkConfiguration.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointNetworkConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> ipAddresses;

    private EndpointNetworkConfiguration(BuilderImpl builder) {
        this.ipAddresses = builder.ipAddresses;
    }

    public final boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpAddresses() ? this.ipAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointNetworkConfiguration)) {
            return false;
        }
        EndpointNetworkConfiguration other = (EndpointNetworkConfiguration)obj;
        return this.hasIpAddresses() == other.hasIpAddresses() && Objects.equals(this.ipAddresses(), other.ipAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointNetworkConfiguration").add("IpAddresses", this.hasIpAddresses() ? this.ipAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("IpAddresses", IP_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointNetworkConfiguration, T> g) {
        return obj -> g.apply((EndpointNetworkConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointNetworkConfiguration model) {
            this.ipAddresses(model.ipAddresses);
        }

        public final Collection<String> getIpAddresses() {
            if (this.ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipAddresses;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressListCopier.copy(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressListCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public EndpointNetworkConfiguration build() {
            return new EndpointNetworkConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointNetworkConfiguration> {
        public Builder ipAddresses(Collection<String> var1);

        public Builder ipAddresses(String ... var1);
    }
}

