/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActiveDirectoryStatus {
    ACCESS_DENIED("ACCESS_DENIED"),
    DETACHED("DETACHED"),
    JOINED("JOINED"),
    JOINING("JOINING"),
    NETWORK_ERROR("NETWORK_ERROR"),
    TIMEOUT("TIMEOUT"),
    UNKNOWN_ERROR("UNKNOWN_ERROR"),
    INSUFFICIENT_PERMISSIONS("INSUFFICIENT_PERMISSIONS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActiveDirectoryStatus> VALUE_MAP;
    private final String value;

    private ActiveDirectoryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActiveDirectoryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActiveDirectoryStatus> knownValues() {
        EnumSet<ActiveDirectoryStatus> knownValues = EnumSet.allOf(ActiveDirectoryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActiveDirectoryStatus.class, ActiveDirectoryStatus::toString);
    }
}

