/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotScheduleResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeSnapshotScheduleResponse> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeARN").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::volumeARN)).setter(DescribeSnapshotScheduleResponse.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<Integer> START_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StartAt").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::startAt)).setter(DescribeSnapshotScheduleResponse.setter(Builder::startAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()}).build();
    private static final SdkField<Integer> RECURRENCE_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RecurrenceInHours").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::recurrenceInHours)).setter(DescribeSnapshotScheduleResponse.setter(Builder::recurrenceInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceInHours").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::description)).setter(DescribeSnapshotScheduleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::timezone)).setter(DescribeSnapshotScheduleResponse.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribeSnapshotScheduleResponse.getter(DescribeSnapshotScheduleResponse::tags)).setter(DescribeSnapshotScheduleResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, START_AT_FIELD, RECURRENCE_IN_HOURS_FIELD, DESCRIPTION_FIELD, TIMEZONE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSnapshotScheduleResponse.memberNameToFieldInitializer();
    private final String volumeARN;
    private final Integer startAt;
    private final Integer recurrenceInHours;
    private final String description;
    private final String timezone;
    private final List<Tag> tags;

    private DescribeSnapshotScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.startAt = builder.startAt;
        this.recurrenceInHours = builder.recurrenceInHours;
        this.description = builder.description;
        this.timezone = builder.timezone;
        this.tags = builder.tags;
    }

    public final String volumeARN() {
        return this.volumeARN;
    }

    public final Integer startAt() {
        return this.startAt;
    }

    public final Integer recurrenceInHours() {
        return this.recurrenceInHours;
    }

    public final String description() {
        return this.description;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrenceInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotScheduleResponse)) {
            return false;
        }
        DescribeSnapshotScheduleResponse other = (DescribeSnapshotScheduleResponse)((Object)obj);
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.startAt(), other.startAt()) && Objects.equals(this.recurrenceInHours(), other.recurrenceInHours()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.timezone(), other.timezone()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotScheduleResponse").add("VolumeARN", (Object)this.volumeARN()).add("StartAt", (Object)this.startAt()).add("RecurrenceInHours", (Object)this.recurrenceInHours()).add("Description", (Object)this.description()).add("Timezone", (Object)this.timezone()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "StartAt": {
                return Optional.ofNullable(clazz.cast(this.startAt()));
            }
            case "RecurrenceInHours": {
                return Optional.ofNullable(clazz.cast(this.recurrenceInHours()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeARN", VOLUME_ARN_FIELD);
        map.put("StartAt", START_AT_FIELD);
        map.put("RecurrenceInHours", RECURRENCE_IN_HOURS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Timezone", TIMEZONE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotScheduleResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String volumeARN;
        private Integer startAt;
        private Integer recurrenceInHours;
        private String description;
        private String timezone;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotScheduleResponse model) {
            super(model);
            this.volumeARN(model.volumeARN);
            this.startAt(model.startAt);
            this.recurrenceInHours(model.recurrenceInHours);
            this.description(model.description);
            this.timezone(model.timezone);
            this.tags(model.tags);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final Integer getStartAt() {
            return this.startAt;
        }

        public final void setStartAt(Integer startAt) {
            this.startAt = startAt;
        }

        @Override
        public final Builder startAt(Integer startAt) {
            this.startAt = startAt;
            return this;
        }

        public final Integer getRecurrenceInHours() {
            return this.recurrenceInHours;
        }

        public final void setRecurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
        }

        @Override
        public final Builder recurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSnapshotScheduleResponse build() {
            return new DescribeSnapshotScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotScheduleResponse> {
        public Builder volumeARN(String var1);

        public Builder startAt(Integer var1);

        public Builder recurrenceInHours(Integer var1);

        public Builder description(String var1);

        public Builder timezone(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

