/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.CacheReportInfo;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListCacheReportsResponse;

public class ListCacheReportsPublisher
implements SdkPublisher<ListCacheReportsResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListCacheReportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCacheReportsPublisher(StorageGatewayAsyncClient client, ListCacheReportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCacheReportsPublisher(StorageGatewayAsyncClient client, ListCacheReportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCacheReportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCacheReportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CacheReportInfo> cacheReportList() {
        Function<ListCacheReportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cacheReportList() != null) {
                return response.cacheReportList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCacheReportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCacheReportsResponseFetcher
    implements AsyncPageFetcher<ListCacheReportsResponse> {
        private ListCacheReportsResponseFetcher() {
        }

        public boolean hasNextPage(ListCacheReportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListCacheReportsResponse> nextPage(ListCacheReportsResponse previousPage) {
            if (previousPage == null) {
                return ListCacheReportsPublisher.this.client.listCacheReports(ListCacheReportsPublisher.this.firstRequest);
            }
            return ListCacheReportsPublisher.this.client.listCacheReports((ListCacheReportsRequest)((Object)ListCacheReportsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

