/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateTapeWithBarcodeInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTapeWithBarcodeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateTapeWithBarcodeRequest.Builder, CreateTapeWithBarcodeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(CreateTapeWithBarcodeRequest::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TapeSizeInBytes").getter(getter(CreateTapeWithBarcodeRequest::tapeSizeInBytes))
            .setter(setter(Builder::tapeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()).build();

    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TapeBarcode").getter(getter(CreateTapeWithBarcodeRequest::tapeBarcode))
            .setter(setter(Builder::tapeBarcode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KMSEncrypted").getter(getter(CreateTapeWithBarcodeRequest::kmsEncrypted))
            .setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(CreateTapeWithBarcodeRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(CreateTapeWithBarcodeRequest::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<Boolean> WORM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Worm")
            .getter(getter(CreateTapeWithBarcodeRequest::worm)).setter(setter(Builder::worm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Worm").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTapeWithBarcodeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TAPE_SIZE_IN_BYTES_FIELD, TAPE_BARCODE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, POOL_ID_FIELD, WORM_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final Long tapeSizeInBytes;

    private final String tapeBarcode;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final String poolId;

    private final Boolean worm;

    private final List<Tag> tags;

    private CreateTapeWithBarcodeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeBarcode = builder.tapeBarcode;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.poolId = builder.poolId;
        this.worm = builder.worm;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the
     * <a>ListGateways</a> operation to return a list of gateways for your account and Amazon Web Services Region.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use
     *         the <a>ListGateways</a> operation to return a list of gateways for your account and Amazon Web Services
     *         Region.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The size, in bytes, of the virtual tape that you want to create.
     * </p>
     * <note>
     * <p>
     * The size must be aligned by gigabyte (1024*1024*1024 bytes).
     * </p>
     * </note>
     * 
     * @return The size, in bytes, of the virtual tape that you want to create.</p> <note>
     *         <p>
     *         The size must be aligned by gigabyte (1024*1024*1024 bytes).
     *         </p>
     */
    public final Long tapeSizeInBytes() {
        return tapeSizeInBytes;
    }

    /**
     * <p>
     * The barcode that you want to assign to the tape.
     * </p>
     * <note>
     * <p>
     * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
     * </p>
     * </note>
     * 
     * @return The barcode that you want to assign to the tape.</p> <note>
     *         <p>
     *         Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
     *         </p>
     */
    public final String tapeBarcode() {
        return tapeBarcode;
    }

    /**
     * <p>
     * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code> to
     * use a key managed by Amazon S3. Optional.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
     *         <code>false</code> to use a key managed by Amazon S3. Optional.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     * <code>KMSEncrypted</code> is <code>true</code>. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     *         encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
     *         <code>KMSEncrypted</code> is <code>true</code>. Optional.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the S3
     * storage class that is associated with the pool. When you use your backup application to eject the tape, the tape
     * is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the pool.
     * </p>
     * 
     * @return The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in
     *         the S3 storage class that is associated with the pool. When you use your backup application to eject the
     *         tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that
     *         corresponds to the pool.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM) tape.
     * </p>
     * 
     * @return Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many
     *         (WORM) tape.
     */
    public final Boolean worm() {
        return worm;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a
     *         key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(worm());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapeWithBarcodeRequest)) {
            return false;
        }
        CreateTapeWithBarcodeRequest other = (CreateTapeWithBarcodeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(tapeSizeInBytes(), other.tapeSizeInBytes())
                && Objects.equals(tapeBarcode(), other.tapeBarcode()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(poolId(), other.poolId())
                && Objects.equals(worm(), other.worm()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTapeWithBarcodeRequest").add("GatewayARN", gatewayARN())
                .add("TapeSizeInBytes", tapeSizeInBytes()).add("TapeBarcode", tapeBarcode()).add("KMSEncrypted", kmsEncrypted())
                .add("KMSKey", kmsKey()).add("PoolId", poolId()).add("Worm", worm()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TapeSizeInBytes":
            return Optional.ofNullable(clazz.cast(tapeSizeInBytes()));
        case "TapeBarcode":
            return Optional.ofNullable(clazz.cast(tapeBarcode()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "Worm":
            return Optional.ofNullable(clazz.cast(worm()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("TapeSizeInBytes", TAPE_SIZE_IN_BYTES_FIELD);
        map.put("TapeBarcode", TAPE_BARCODE_FIELD);
        map.put("KMSEncrypted", KMS_ENCRYPTED_FIELD);
        map.put("KMSKey", KMS_KEY_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("Worm", WORM_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTapeWithBarcodeRequest, T> g) {
        return obj -> g.apply((CreateTapeWithBarcodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTapeWithBarcodeRequest> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with. Use the
         * <a>ListGateways</a> operation to return a list of gateways for your account and Amazon Web Services Region.
         * </p>
         * 
         * @param gatewayARN
         *        The unique Amazon Resource Name (ARN) that represents the gateway to associate the virtual tape with.
         *        Use the <a>ListGateways</a> operation to return a list of gateways for your account and Amazon Web
         *        Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The size, in bytes, of the virtual tape that you want to create.
         * </p>
         * <note>
         * <p>
         * The size must be aligned by gigabyte (1024*1024*1024 bytes).
         * </p>
         * </note>
         * 
         * @param tapeSizeInBytes
         *        The size, in bytes, of the virtual tape that you want to create.</p> <note>
         *        <p>
         *        The size must be aligned by gigabyte (1024*1024*1024 bytes).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeSizeInBytes(Long tapeSizeInBytes);

        /**
         * <p>
         * The barcode that you want to assign to the tape.
         * </p>
         * <note>
         * <p>
         * Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
         * </p>
         * </note>
         * 
         * @param tapeBarcode
         *        The barcode that you want to assign to the tape.</p> <note>
         *        <p>
         *        Barcodes cannot be reused. This includes barcodes used for tapes that have been deleted.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeBarcode(String tapeBarcode);

        /**
         * <p>
         * Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or <code>false</code>
         * to use a key managed by Amazon S3. Optional.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param kmsEncrypted
         *        Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key, or
         *        <code>false</code> to use a key managed by Amazon S3. Optional.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         * encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         * <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
         *        encryption. Storage Gateway does not support asymmetric CMKs. This value can only be set when
         *        <code>KMSEncrypted</code> is <code>true</code>. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived in the
         * S3 storage class that is associated with the pool. When you use your backup application to eject the tape,
         * the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive) that corresponds to the
         * pool.
         * </p>
         * 
         * @param poolId
         *        The ID of the pool that you want to add your tape to for archiving. The tape in this pool is archived
         *        in the S3 storage class that is associated with the pool. When you use your backup application to
         *        eject the tape, the tape is archived directly into the storage class (S3 Glacier or S3 Deep Archive)
         *        that corresponds to the pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many (WORM)
         * tape.
         * </p>
         * 
         * @param worm
         *        Set to <code>TRUE</code> if the tape you are creating is to be configured as a write-once-read-many
         *        (WORM) tape.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worm(Boolean worm);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value
         * pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a
         *        key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value
         * pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a
         *        key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a virtual tape that has a barcode. Each tag is a key-value
         * pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.storagegateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Long tapeSizeInBytes;

        private String tapeBarcode;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private String poolId;

        private Boolean worm;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapeWithBarcodeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            tapeSizeInBytes(model.tapeSizeInBytes);
            tapeBarcode(model.tapeBarcode);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            poolId(model.poolId);
            worm(model.worm);
            tags(model.tags);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Long getTapeSizeInBytes() {
            return tapeSizeInBytes;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final String getTapeBarcode() {
            return tapeBarcode;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Boolean getWorm() {
            return worm;
        }

        public final void setWorm(Boolean worm) {
            this.worm = worm;
        }

        @Override
        public final Builder worm(Boolean worm) {
            this.worm = worm;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapeWithBarcodeRequest build() {
            return new CreateTapeWithBarcodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
