/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DeleteFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DeleteFileShareRequest.Builder, DeleteFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(DeleteFileShareRequest::fileShareARN))
            .setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDelete").getter(getter(DeleteFileShareRequest::forceDelete)).setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDelete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            FORCE_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileShareARN;

    private final Boolean forceDelete;

    private DeleteFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.forceDelete = builder.forceDelete;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file share to be deleted.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file share to be deleted.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data
     * uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon Web
     * Services. This process aborts the data upload process, and the file share enters the <code>FORCE_DELETING</code>
     * status.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all
     *         data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded
     *         to Amazon Web Services. This process aborts the data upload process, and the file share enters the
     *         <code>FORCE_DELETING</code> status.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileShareRequest)) {
            return false;
        }
        DeleteFileShareRequest other = (DeleteFileShareRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(forceDelete(), other.forceDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileShareRequest").add("FileShareARN", fileShareARN()).add("ForceDelete", forceDelete())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "ForceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("ForceDelete", FORCE_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileShareRequest, T> g) {
        return obj -> g.apply((DeleteFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFileShareRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file share to be deleted.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the file share to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts all data
         * uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is uploaded to Amazon
         * Web Services. This process aborts the data upload process, and the file share enters the
         * <code>FORCE_DELETING</code> status.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param forceDelete
         *        If this value is set to <code>true</code>, the operation deletes a file share immediately and aborts
         *        all data uploads to Amazon Web Services. Otherwise, the file share is not deleted until all data is
         *        uploaded to Amazon Web Services. This process aborts the data upload process, and the file share
         *        enters the <code>FORCE_DELETING</code> status.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private Boolean forceDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileShareRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            forceDelete(model.forceDelete);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileShareRequest build() {
            return new DeleteFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
