/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeTapeArchivesInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTapeArchivesRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<DescribeTapeArchivesRequest.Builder, DescribeTapeArchivesRequest> {
    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TapeARNs")
            .getter(getter(DescribeTapeArchivesRequest::tapeARNs))
            .setter(setter(Builder::tapeARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTapeArchivesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeTapeArchivesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_AR_NS_FIELD,
            MARKER_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> tapeARNs;

    private final String marker;

    private final Integer limit;

    private DescribeTapeArchivesRequest(BuilderImpl builder) {
        super(builder);
        this.tapeARNs = builder.tapeARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    /**
     * For responses, this returns true if the service returned a value for the TapeARNs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTapeARNs() {
        return tapeARNs != null && !(tapeARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTapeARNs} method.
     * </p>
     * 
     * @return Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
     *         describe.
     */
    public final List<String> tapeARNs() {
        return tapeARNs;
    }

    /**
     * <p>
     * An opaque string that indicates the position at which to begin describing virtual tapes.
     * </p>
     * 
     * @return An opaque string that indicates the position at which to begin describing virtual tapes.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Specifies that the number of virtual tapes described be limited to the specified number.
     * </p>
     * 
     * @return Specifies that the number of virtual tapes described be limited to the specified number.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTapeARNs() ? tapeARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapeArchivesRequest)) {
            return false;
        }
        DescribeTapeArchivesRequest other = (DescribeTapeArchivesRequest) obj;
        return hasTapeARNs() == other.hasTapeARNs() && Objects.equals(tapeARNs(), other.tapeARNs())
                && Objects.equals(marker(), other.marker()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTapeArchivesRequest").add("TapeARNs", hasTapeARNs() ? tapeARNs() : null)
                .add("Marker", marker()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TapeARNs":
            return Optional.ofNullable(clazz.cast(tapeARNs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TapeARNs", TAPE_AR_NS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapeArchivesRequest, T> g) {
        return obj -> g.apply((DescribeTapeArchivesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTapeArchivesRequest> {
        /**
         * <p>
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         * describe.
         * </p>
         * 
         * @param tapeARNs
         *        Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         *        describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(Collection<String> tapeARNs);

        /**
         * <p>
         * Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         * describe.
         * </p>
         * 
         * @param tapeARNs
         *        Specifies one or more unique Amazon Resource Names (ARNs) that represent the virtual tapes you want to
         *        describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tapeARNs(String... tapeARNs);

        /**
         * <p>
         * An opaque string that indicates the position at which to begin describing virtual tapes.
         * </p>
         * 
         * @param marker
         *        An opaque string that indicates the position at which to begin describing virtual tapes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Specifies that the number of virtual tapes described be limited to the specified number.
         * </p>
         * 
         * @param limit
         *        Specifies that the number of virtual tapes described be limited to the specified number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapeArchivesRequest model) {
            super(model);
            tapeARNs(model.tapeARNs);
            marker(model.marker);
            limit(model.limit);
        }

        public final Collection<String> getTapeARNs() {
            if (tapeARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return tapeARNs;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String... tapeARNs) {
            tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTapeArchivesRequest build() {
            return new DescribeTapeArchivesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
