/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUploadBufferResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeUploadBufferResponse.Builder, DescribeUploadBufferResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(DescribeUploadBufferResponse::gatewayARN))
            .setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DiskIds")
            .getter(getter(DescribeUploadBufferResponse::diskIds))
            .setter(setter(Builder::diskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> UPLOAD_BUFFER_USED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UploadBufferUsedInBytes").getter(getter(DescribeUploadBufferResponse::uploadBufferUsedInBytes))
            .setter(setter(Builder::uploadBufferUsedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadBufferUsedInBytes").build())
            .build();

    private static final SdkField<Long> UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("UploadBufferAllocatedInBytes")
            .getter(getter(DescribeUploadBufferResponse::uploadBufferAllocatedInBytes))
            .setter(setter(Builder::uploadBufferAllocatedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadBufferAllocatedInBytes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DISK_IDS_FIELD, UPLOAD_BUFFER_USED_IN_BYTES_FIELD, UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final List<String> diskIds;

    private final Long uploadBufferUsedInBytes;

    private final Long uploadBufferAllocatedInBytes;

    private DescribeUploadBufferResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
        this.uploadBufferUsedInBytes = builder.uploadBufferUsedInBytes;
        this.uploadBufferAllocatedInBytes = builder.uploadBufferAllocatedInBytes;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the DiskIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDiskIds() {
        return diskIds != null && !(diskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is specified
     * as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as working storage,
     * then the DiskIds array is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDiskIds} method.
     * </p>
     * 
     * @return An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
     *         specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured
     *         as working storage, then the DiskIds array is empty.
     */
    public final List<String> diskIds() {
        return diskIds;
    }

    /**
     * <p>
     * The total number of bytes being used in the gateway's upload buffer.
     * </p>
     * 
     * @return The total number of bytes being used in the gateway's upload buffer.
     */
    public final Long uploadBufferUsedInBytes() {
        return uploadBufferUsedInBytes;
    }

    /**
     * <p>
     * The total number of bytes allocated in the gateway's as upload buffer.
     * </p>
     * 
     * @return The total number of bytes allocated in the gateway's as upload buffer.
     */
    public final Long uploadBufferAllocatedInBytes() {
        return uploadBufferAllocatedInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasDiskIds() ? diskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uploadBufferUsedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(uploadBufferAllocatedInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUploadBufferResponse)) {
            return false;
        }
        DescribeUploadBufferResponse other = (DescribeUploadBufferResponse) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && hasDiskIds() == other.hasDiskIds()
                && Objects.equals(diskIds(), other.diskIds())
                && Objects.equals(uploadBufferUsedInBytes(), other.uploadBufferUsedInBytes())
                && Objects.equals(uploadBufferAllocatedInBytes(), other.uploadBufferAllocatedInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUploadBufferResponse").add("GatewayARN", gatewayARN())
                .add("DiskIds", hasDiskIds() ? diskIds() : null).add("UploadBufferUsedInBytes", uploadBufferUsedInBytes())
                .add("UploadBufferAllocatedInBytes", uploadBufferAllocatedInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DiskIds":
            return Optional.ofNullable(clazz.cast(diskIds()));
        case "UploadBufferUsedInBytes":
            return Optional.ofNullable(clazz.cast(uploadBufferUsedInBytes()));
        case "UploadBufferAllocatedInBytes":
            return Optional.ofNullable(clazz.cast(uploadBufferAllocatedInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DiskIds", DISK_IDS_FIELD);
        map.put("UploadBufferUsedInBytes", UPLOAD_BUFFER_USED_IN_BYTES_FIELD);
        map.put("UploadBufferAllocatedInBytes", UPLOAD_BUFFER_ALLOCATED_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUploadBufferResponse, T> g) {
        return obj -> g.apply((DescribeUploadBufferResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUploadBufferResponse> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         * specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as
         * working storage, then the DiskIds array is empty.
         * </p>
         * 
         * @param diskIds
         *        An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         *        specified as a string (minimum length of 1 and maximum length of 300). If no local disks are
         *        configured as working storage, then the DiskIds array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(Collection<String> diskIds);

        /**
         * <p>
         * An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         * specified as a string (minimum length of 1 and maximum length of 300). If no local disks are configured as
         * working storage, then the DiskIds array is empty.
         * </p>
         * 
         * @param diskIds
         *        An array of the gateway's local disk IDs that are configured as working storage. Each local disk ID is
         *        specified as a string (minimum length of 1 and maximum length of 300). If no local disks are
         *        configured as working storage, then the DiskIds array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(String... diskIds);

        /**
         * <p>
         * The total number of bytes being used in the gateway's upload buffer.
         * </p>
         * 
         * @param uploadBufferUsedInBytes
         *        The total number of bytes being used in the gateway's upload buffer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadBufferUsedInBytes(Long uploadBufferUsedInBytes);

        /**
         * <p>
         * The total number of bytes allocated in the gateway's as upload buffer.
         * </p>
         * 
         * @param uploadBufferAllocatedInBytes
         *        The total number of bytes allocated in the gateway's as upload buffer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadBufferAllocatedInBytes(Long uploadBufferAllocatedInBytes);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();

        private Long uploadBufferUsedInBytes;

        private Long uploadBufferAllocatedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUploadBufferResponse model) {
            super(model);
            gatewayARN(model.gatewayARN);
            diskIds(model.diskIds);
            uploadBufferUsedInBytes(model.uploadBufferUsedInBytes);
            uploadBufferAllocatedInBytes(model.uploadBufferAllocatedInBytes);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Collection<String> getDiskIds() {
            if (diskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return diskIds;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String... diskIds) {
            diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final Long getUploadBufferUsedInBytes() {
            return uploadBufferUsedInBytes;
        }

        public final void setUploadBufferUsedInBytes(Long uploadBufferUsedInBytes) {
            this.uploadBufferUsedInBytes = uploadBufferUsedInBytes;
        }

        @Override
        public final Builder uploadBufferUsedInBytes(Long uploadBufferUsedInBytes) {
            this.uploadBufferUsedInBytes = uploadBufferUsedInBytes;
            return this;
        }

        public final Long getUploadBufferAllocatedInBytes() {
            return uploadBufferAllocatedInBytes;
        }

        public final void setUploadBufferAllocatedInBytes(Long uploadBufferAllocatedInBytes) {
            this.uploadBufferAllocatedInBytes = uploadBufferAllocatedInBytes;
        }

        @Override
        public final Builder uploadBufferAllocatedInBytes(Long uploadBufferAllocatedInBytes) {
            this.uploadBufferAllocatedInBytes = uploadBufferAllocatedInBytes;
            return this;
        }

        @Override
        public DescribeUploadBufferResponse build() {
            return new DescribeUploadBufferResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
