/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvictFilesFailingUploadRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<EvictFilesFailingUploadRequest.Builder, EvictFilesFailingUploadRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(EvictFilesFailingUploadRequest::fileShareARN))
            .setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<Boolean> FORCE_REMOVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceRemove").getter(getter(EvictFilesFailingUploadRequest::forceRemove))
            .setter(setter(Builder::forceRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceRemove").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            FORCE_REMOVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileShareARN;

    private final Boolean forceRemove;

    private EvictFilesFailingUploadRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.forceRemove = builder.forceRemove;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file share for which you want to start the cache clean operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file share for which you want to start the cache clean operation.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * Specifies whether cache entries with full or partial file data currently stored on the gateway will be forcibly
     * removed by the cache clean operation.
     * </p>
     * <p>
     * Valid arguments:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>False</code> - The cache clean operation skips cache entries failing upload if they are associated with
     * data currently stored on the gateway. This preserves the cached data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>True</code> - The cache clean operation removes cache entries failing upload even if they are associated
     * with data currently stored on the gateway. This deletes the cached data.
     * </p>
     * <important>
     * <p>
     * If <code>ForceRemove</code> is set to <code>True</code>, the cache clean operation will delete file data from the
     * gateway which might otherwise be recoverable.
     * </p>
     * </important></li>
     * </ul>
     * 
     * @return Specifies whether cache entries with full or partial file data currently stored on the gateway will be
     *         forcibly removed by the cache clean operation.</p>
     *         <p>
     *         Valid arguments:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>False</code> - The cache clean operation skips cache entries failing upload if they are associated
     *         with data currently stored on the gateway. This preserves the cached data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>True</code> - The cache clean operation removes cache entries failing upload even if they are
     *         associated with data currently stored on the gateway. This deletes the cached data.
     *         </p>
     *         <important>
     *         <p>
     *         If <code>ForceRemove</code> is set to <code>True</code>, the cache clean operation will delete file data
     *         from the gateway which might otherwise be recoverable.
     *         </p>
     *         </important></li>
     */
    public final Boolean forceRemove() {
        return forceRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(forceRemove());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvictFilesFailingUploadRequest)) {
            return false;
        }
        EvictFilesFailingUploadRequest other = (EvictFilesFailingUploadRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN()) && Objects.equals(forceRemove(), other.forceRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvictFilesFailingUploadRequest").add("FileShareARN", fileShareARN())
                .add("ForceRemove", forceRemove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "ForceRemove":
            return Optional.ofNullable(clazz.cast(forceRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("ForceRemove", FORCE_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvictFilesFailingUploadRequest, T> g) {
        return obj -> g.apply((EvictFilesFailingUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EvictFilesFailingUploadRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file share for which you want to start the cache clean operation.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the file share for which you want to start the cache clean
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * Specifies whether cache entries with full or partial file data currently stored on the gateway will be
         * forcibly removed by the cache clean operation.
         * </p>
         * <p>
         * Valid arguments:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>False</code> - The cache clean operation skips cache entries failing upload if they are associated with
         * data currently stored on the gateway. This preserves the cached data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>True</code> - The cache clean operation removes cache entries failing upload even if they are
         * associated with data currently stored on the gateway. This deletes the cached data.
         * </p>
         * <important>
         * <p>
         * If <code>ForceRemove</code> is set to <code>True</code>, the cache clean operation will delete file data from
         * the gateway which might otherwise be recoverable.
         * </p>
         * </important></li>
         * </ul>
         * 
         * @param forceRemove
         *        Specifies whether cache entries with full or partial file data currently stored on the gateway will be
         *        forcibly removed by the cache clean operation.</p>
         *        <p>
         *        Valid arguments:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>False</code> - The cache clean operation skips cache entries failing upload if they are
         *        associated with data currently stored on the gateway. This preserves the cached data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>True</code> - The cache clean operation removes cache entries failing upload even if they are
         *        associated with data currently stored on the gateway. This deletes the cached data.
         *        </p>
         *        <important>
         *        <p>
         *        If <code>ForceRemove</code> is set to <code>True</code>, the cache clean operation will delete file
         *        data from the gateway which might otherwise be recoverable.
         *        </p>
         *        </important></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceRemove(Boolean forceRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private Boolean forceRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(EvictFilesFailingUploadRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            forceRemove(model.forceRemove);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final Boolean getForceRemove() {
            return forceRemove;
        }

        public final void setForceRemove(Boolean forceRemove) {
            this.forceRemove = forceRemove;
        }

        @Override
        public final Builder forceRemove(Boolean forceRemove) {
            this.forceRemove = forceRemove;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvictFilesFailingUploadRequest build() {
            return new EvictFilesFailingUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
