/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * JoinDomainInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinDomainRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<JoinDomainRequest.Builder, JoinDomainRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(JoinDomainRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(JoinDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnit").getter(getter(JoinDomainRequest::organizationalUnit))
            .setter(setter(Builder::organizationalUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build())
            .build();

    private static final SdkField<List<String>> DOMAIN_CONTROLLERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DomainControllers")
            .getter(getter(JoinDomainRequest::domainControllers))
            .setter(setter(Builder::domainControllers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInSeconds").getter(getter(JoinDomainRequest::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(JoinDomainRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(JoinDomainRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_FIELD, DOMAIN_CONTROLLERS_FIELD, TIMEOUT_IN_SECONDS_FIELD, USER_NAME_FIELD,
            PASSWORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final String domainName;

    private final String organizationalUnit;

    private final List<String> domainControllers;

    private final Integer timeoutInSeconds;

    private final String userName;

    private final String password;

    private JoinDomainRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.organizationalUnit = builder.organizationalUnit;
        this.domainControllers = builder.domainControllers;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.userName = builder.userName;
        this.password = builder.password;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of
     * gateways for your account and Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
     *         list of gateways for your account and Amazon Web Services Region.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the domain that you want the gateway to join.
     * </p>
     * 
     * @return The name of the domain that you want the gateway to join.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers, and
     * other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
     * </p>
     * 
     * @return The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
     *         computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD
     *         domain.
     */
    public final String organizationalUnit() {
        return organizationalUnit;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainControllers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainControllers() {
        return domainControllers != null && !(domainControllers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the port number
     * include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
     * </p>
     * <note>
     * <p>
     * S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
     * </p>
     * <p>
     * FSx File Gateway does not support IPv6.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainControllers} method.
     * </p>
     * 
     * @return List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
     *         number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p> <note>
     *         <p>
     *         S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
     *         </p>
     *         <p>
     *         FSx File Gateway does not support IPv6.
     *         </p>
     */
    public final List<String> domainControllers() {
        return domainControllers;
    }

    /**
     * <p>
     * Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is 20
     * seconds.
     * </p>
     * 
     * @return Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default
     *         is 20 seconds.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain user
     * account should be enabled to join computers to the domain. For example, you can use the domain administrator
     * account or an account with delegated permissions to join computers to the domain.
     * </p>
     * 
     * @return Sets the user name of user who has permission to add the gateway to the Active Directory domain. The
     *         domain user account should be enabled to join computers to the domain. For example, you can use the
     *         domain administrator account or an account with delegated permissions to join computers to the domain.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     * </p>
     * 
     * @return Sets the password of the user who has permission to add the gateway to the Active Directory domain.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnit());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainControllers() ? domainControllers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainRequest)) {
            return false;
        }
        JoinDomainRequest other = (JoinDomainRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(organizationalUnit(), other.organizationalUnit())
                && hasDomainControllers() == other.hasDomainControllers()
                && Objects.equals(domainControllers(), other.domainControllers())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(userName(), other.userName())
                && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinDomainRequest").add("GatewayARN", gatewayARN()).add("DomainName", domainName())
                .add("OrganizationalUnit", organizationalUnit())
                .add("DomainControllers", hasDomainControllers() ? domainControllers() : null)
                .add("TimeoutInSeconds", timeoutInSeconds()).add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "OrganizationalUnit":
            return Optional.ofNullable(clazz.cast(organizationalUnit()));
        case "DomainControllers":
            return Optional.ofNullable(clazz.cast(domainControllers()));
        case "TimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("OrganizationalUnit", ORGANIZATIONAL_UNIT_FIELD);
        map.put("DomainControllers", DOMAIN_CONTROLLERS_FIELD);
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainRequest, T> g) {
        return obj -> g.apply((JoinDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, JoinDomainRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list
         * of gateways for your account and Amazon Web Services Region.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
         *        list of gateways for your account and Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the domain that you want the gateway to join.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want the gateway to join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The organizational unit (OU) is a container in an Active Directory that can hold users, groups, computers,
         * and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
         * </p>
         * 
         * @param organizationalUnit
         *        The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
         *        computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnit(String organizationalUnit);

        /**
         * <p>
         * List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
         * number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * </p>
         * <note>
         * <p>
         * S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
         * </p>
         * <p>
         * FSx File Gateway does not support IPv6.
         * </p>
         * </note>
         * 
         * @param domainControllers
         *        List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the
         *        port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>
         *        <note>
         *        <p>
         *        S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
         *        </p>
         *        <p>
         *        FSx File Gateway does not support IPv6.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(Collection<String> domainControllers);

        /**
         * <p>
         * List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the port
         * number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.
         * </p>
         * <note>
         * <p>
         * S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
         * </p>
         * <p>
         * FSx File Gateway does not support IPv6.
         * </p>
         * </note>
         * 
         * @param domainControllers
         *        List of IP addresses, NetBIOS names, or host names of your domain server. If you need to specify the
         *        port number include it after the colon (“:”). For example, <code>mydc.mydomain.com:389</code>.</p>
         *        <note>
         *        <p>
         *        S3 File Gateway supports IPv6 addresses in addition to IPv4 and other existing formats.
         *        </p>
         *        <p>
         *        FSx File Gateway does not support IPv6.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(String... domainControllers);

        /**
         * <p>
         * Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The default is
         * 20 seconds.
         * </p>
         * 
         * @param timeoutInSeconds
         *        Specifies the time in seconds, in which the <code>JoinDomain</code> operation must complete. The
         *        default is 20 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * Sets the user name of user who has permission to add the gateway to the Active Directory domain. The domain
         * user account should be enabled to join computers to the domain. For example, you can use the domain
         * administrator account or an account with delegated permissions to join computers to the domain.
         * </p>
         * 
         * @param userName
         *        Sets the user name of user who has permission to add the gateway to the Active Directory domain. The
         *        domain user account should be enabled to join computers to the domain. For example, you can use the
         *        domain administrator account or an account with delegated permissions to join computers to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * </p>
         * 
         * @param password
         *        Sets the password of the user who has permission to add the gateway to the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String domainName;

        private String organizationalUnit;

        private List<String> domainControllers = DefaultSdkAutoConstructList.getInstance();

        private Integer timeoutInSeconds;

        private String userName;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            domainName(model.domainName);
            organizationalUnit(model.organizationalUnit);
            domainControllers(model.domainControllers);
            timeoutInSeconds(model.timeoutInSeconds);
            userName(model.userName);
            password(model.password);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getOrganizationalUnit() {
            return organizationalUnit;
        }

        public final void setOrganizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
        }

        @Override
        public final Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public final Collection<String> getDomainControllers() {
            if (domainControllers instanceof SdkAutoConstructList) {
                return null;
            }
            return domainControllers;
        }

        public final void setDomainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
        }

        @Override
        public final Builder domainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(String... domainControllers) {
            domainControllers(Arrays.asList(domainControllers));
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public JoinDomainRequest build() {
            return new JoinDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
