/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutomaticTapeCreationPoliciesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListAutomaticTapeCreationPoliciesResponse.Builder, ListAutomaticTapeCreationPoliciesResponse> {
    private static final SdkField<List<AutomaticTapeCreationPolicyInfo>> AUTOMATIC_TAPE_CREATION_POLICY_INFOS_FIELD = SdkField
            .<List<AutomaticTapeCreationPolicyInfo>> builder(MarshallingType.LIST)
            .memberName("AutomaticTapeCreationPolicyInfos")
            .getter(getter(ListAutomaticTapeCreationPoliciesResponse::automaticTapeCreationPolicyInfos))
            .setter(setter(Builder::automaticTapeCreationPolicyInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticTapeCreationPolicyInfos")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomaticTapeCreationPolicyInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomaticTapeCreationPolicyInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTOMATIC_TAPE_CREATION_POLICY_INFOS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AutomaticTapeCreationPolicyInfo> automaticTapeCreationPolicyInfos;

    private ListAutomaticTapeCreationPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.automaticTapeCreationPolicyInfos = builder.automaticTapeCreationPolicyInfos;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutomaticTapeCreationPolicyInfos
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAutomaticTapeCreationPolicyInfos() {
        return automaticTapeCreationPolicyInfos != null && !(automaticTapeCreationPolicyInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets a listing of information about the gateway's automatic tape creation policies, including the automatic tape
     * creation rules and the gateway that is using the policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutomaticTapeCreationPolicyInfos}
     * method.
     * </p>
     * 
     * @return Gets a listing of information about the gateway's automatic tape creation policies, including the
     *         automatic tape creation rules and the gateway that is using the policies.
     */
    public final List<AutomaticTapeCreationPolicyInfo> automaticTapeCreationPolicyInfos() {
        return automaticTapeCreationPolicyInfos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAutomaticTapeCreationPolicyInfos() ? automaticTapeCreationPolicyInfos() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomaticTapeCreationPoliciesResponse)) {
            return false;
        }
        ListAutomaticTapeCreationPoliciesResponse other = (ListAutomaticTapeCreationPoliciesResponse) obj;
        return hasAutomaticTapeCreationPolicyInfos() == other.hasAutomaticTapeCreationPolicyInfos()
                && Objects.equals(automaticTapeCreationPolicyInfos(), other.automaticTapeCreationPolicyInfos());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAutomaticTapeCreationPoliciesResponse")
                .add("AutomaticTapeCreationPolicyInfos",
                        hasAutomaticTapeCreationPolicyInfos() ? automaticTapeCreationPolicyInfos() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticTapeCreationPolicyInfos":
            return Optional.ofNullable(clazz.cast(automaticTapeCreationPolicyInfos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutomaticTapeCreationPolicyInfos", AUTOMATIC_TAPE_CREATION_POLICY_INFOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomaticTapeCreationPoliciesResponse, T> g) {
        return obj -> g.apply((ListAutomaticTapeCreationPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAutomaticTapeCreationPoliciesResponse> {
        /**
         * <p>
         * Gets a listing of information about the gateway's automatic tape creation policies, including the automatic
         * tape creation rules and the gateway that is using the policies.
         * </p>
         * 
         * @param automaticTapeCreationPolicyInfos
         *        Gets a listing of information about the gateway's automatic tape creation policies, including the
         *        automatic tape creation rules and the gateway that is using the policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationPolicyInfos(Collection<AutomaticTapeCreationPolicyInfo> automaticTapeCreationPolicyInfos);

        /**
         * <p>
         * Gets a listing of information about the gateway's automatic tape creation policies, including the automatic
         * tape creation rules and the gateway that is using the policies.
         * </p>
         * 
         * @param automaticTapeCreationPolicyInfos
         *        Gets a listing of information about the gateway's automatic tape creation policies, including the
         *        automatic tape creation rules and the gateway that is using the policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticTapeCreationPolicyInfos(AutomaticTapeCreationPolicyInfo... automaticTapeCreationPolicyInfos);

        /**
         * <p>
         * Gets a listing of information about the gateway's automatic tape creation policies, including the automatic
         * tape creation rules and the gateway that is using the policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #automaticTapeCreationPolicyInfos(List<AutomaticTapeCreationPolicyInfo>)}.
         * 
         * @param automaticTapeCreationPolicyInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.AutomaticTapeCreationPolicyInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automaticTapeCreationPolicyInfos(java.util.Collection<AutomaticTapeCreationPolicyInfo>)
         */
        Builder automaticTapeCreationPolicyInfos(
                Consumer<AutomaticTapeCreationPolicyInfo.Builder>... automaticTapeCreationPolicyInfos);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<AutomaticTapeCreationPolicyInfo> automaticTapeCreationPolicyInfos = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomaticTapeCreationPoliciesResponse model) {
            super(model);
            automaticTapeCreationPolicyInfos(model.automaticTapeCreationPolicyInfos);
        }

        public final List<AutomaticTapeCreationPolicyInfo.Builder> getAutomaticTapeCreationPolicyInfos() {
            List<AutomaticTapeCreationPolicyInfo.Builder> result = AutomaticTapeCreationPolicyInfosCopier
                    .copyToBuilder(this.automaticTapeCreationPolicyInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutomaticTapeCreationPolicyInfos(
                Collection<AutomaticTapeCreationPolicyInfo.BuilderImpl> automaticTapeCreationPolicyInfos) {
            this.automaticTapeCreationPolicyInfos = AutomaticTapeCreationPolicyInfosCopier
                    .copyFromBuilder(automaticTapeCreationPolicyInfos);
        }

        @Override
        public final Builder automaticTapeCreationPolicyInfos(
                Collection<AutomaticTapeCreationPolicyInfo> automaticTapeCreationPolicyInfos) {
            this.automaticTapeCreationPolicyInfos = AutomaticTapeCreationPolicyInfosCopier.copy(automaticTapeCreationPolicyInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationPolicyInfos(AutomaticTapeCreationPolicyInfo... automaticTapeCreationPolicyInfos) {
            automaticTapeCreationPolicyInfos(Arrays.asList(automaticTapeCreationPolicyInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder automaticTapeCreationPolicyInfos(
                Consumer<AutomaticTapeCreationPolicyInfo.Builder>... automaticTapeCreationPolicyInfos) {
            automaticTapeCreationPolicyInfos(Stream.of(automaticTapeCreationPolicyInfos)
                    .map(c -> AutomaticTapeCreationPolicyInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAutomaticTapeCreationPoliciesResponse build() {
            return new ListAutomaticTapeCreationPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
