/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCacheReportsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListCacheReportsResponse.Builder, ListCacheReportsResponse> {
    private static final SdkField<List<CacheReportInfo>> CACHE_REPORT_LIST_FIELD = SdkField
            .<List<CacheReportInfo>> builder(MarshallingType.LIST)
            .memberName("CacheReportList")
            .getter(getter(ListCacheReportsResponse::cacheReportList))
            .setter(setter(Builder::cacheReportList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CacheReportInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(CacheReportInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListCacheReportsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_REPORT_LIST_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CacheReportInfo> cacheReportList;

    private final String marker;

    private ListCacheReportsResponse(BuilderImpl builder) {
        super(builder);
        this.cacheReportList = builder.cacheReportList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheReportList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheReportList() {
        return cacheReportList != null && !(cacheReportList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of existing cache reports for all file shares associated with your Amazon Web Services account. This list
     * includes all information provided by the <code>DescribeCacheReport</code> action, such as report status,
     * completion progress, start time, end time, filters, and tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheReportList} method.
     * </p>
     * 
     * @return A list of existing cache reports for all file shares associated with your Amazon Web Services account.
     *         This list includes all information provided by the <code>DescribeCacheReport</code> action, such as
     *         report status, completion progress, start time, end time, filters, and tags.
     */
    public final List<CacheReportInfo> cacheReportList() {
        return cacheReportList;
    }

    /**
     * <p>
     * If the request includes <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request includes <code>Marker</code>, the response returns that value in this field.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheReportList() ? cacheReportList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCacheReportsResponse)) {
            return false;
        }
        ListCacheReportsResponse other = (ListCacheReportsResponse) obj;
        return hasCacheReportList() == other.hasCacheReportList() && Objects.equals(cacheReportList(), other.cacheReportList())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCacheReportsResponse")
                .add("CacheReportList", hasCacheReportList() ? cacheReportList() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheReportList":
            return Optional.ofNullable(clazz.cast(cacheReportList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheReportList", CACHE_REPORT_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCacheReportsResponse, T> g) {
        return obj -> g.apply((ListCacheReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCacheReportsResponse> {
        /**
         * <p>
         * A list of existing cache reports for all file shares associated with your Amazon Web Services account. This
         * list includes all information provided by the <code>DescribeCacheReport</code> action, such as report status,
         * completion progress, start time, end time, filters, and tags.
         * </p>
         * 
         * @param cacheReportList
         *        A list of existing cache reports for all file shares associated with your Amazon Web Services account.
         *        This list includes all information provided by the <code>DescribeCacheReport</code> action, such as
         *        report status, completion progress, start time, end time, filters, and tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheReportList(Collection<CacheReportInfo> cacheReportList);

        /**
         * <p>
         * A list of existing cache reports for all file shares associated with your Amazon Web Services account. This
         * list includes all information provided by the <code>DescribeCacheReport</code> action, such as report status,
         * completion progress, start time, end time, filters, and tags.
         * </p>
         * 
         * @param cacheReportList
         *        A list of existing cache reports for all file shares associated with your Amazon Web Services account.
         *        This list includes all information provided by the <code>DescribeCacheReport</code> action, such as
         *        report status, completion progress, start time, end time, filters, and tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheReportList(CacheReportInfo... cacheReportList);

        /**
         * <p>
         * A list of existing cache reports for all file shares associated with your Amazon Web Services account. This
         * list includes all information provided by the <code>DescribeCacheReport</code> action, such as report status,
         * completion progress, start time, end time, filters, and tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.storagegateway.model.CacheReportInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #cacheReportList(List<CacheReportInfo>)}.
         * 
         * @param cacheReportList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.storagegateway.model.CacheReportInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheReportList(java.util.Collection<CacheReportInfo>)
         */
        Builder cacheReportList(Consumer<CacheReportInfo.Builder>... cacheReportList);

        /**
         * <p>
         * If the request includes <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request includes <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<CacheReportInfo> cacheReportList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCacheReportsResponse model) {
            super(model);
            cacheReportList(model.cacheReportList);
            marker(model.marker);
        }

        public final List<CacheReportInfo.Builder> getCacheReportList() {
            List<CacheReportInfo.Builder> result = CacheReportListCopier.copyToBuilder(this.cacheReportList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheReportList(Collection<CacheReportInfo.BuilderImpl> cacheReportList) {
            this.cacheReportList = CacheReportListCopier.copyFromBuilder(cacheReportList);
        }

        @Override
        public final Builder cacheReportList(Collection<CacheReportInfo> cacheReportList) {
            this.cacheReportList = CacheReportListCopier.copy(cacheReportList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheReportList(CacheReportInfo... cacheReportList) {
            cacheReportList(Arrays.asList(cacheReportList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheReportList(Consumer<CacheReportInfo.Builder>... cacheReportList) {
            cacheReportList(Stream.of(cacheReportList).map(c -> CacheReportInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListCacheReportsResponse build() {
            return new ListCacheReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
