/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTapePoolsRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<ListTapePoolsRequest.Builder, ListTapePoolsRequest> {
    private static final SdkField<List<String>> POOL_AR_NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PoolARNs")
            .getter(getter(ListTapePoolsRequest::poolARNs))
            .setter(setter(Builder::poolARNs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolARNs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListTapePoolsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListTapePoolsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_AR_NS_FIELD,
            MARKER_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> poolARNs;

    private final String marker;

    private final Integer limit;

    private ListTapePoolsRequest(BuilderImpl builder) {
        super(builder);
        this.poolARNs = builder.poolARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    /**
     * For responses, this returns true if the service returned a value for the PoolARNs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPoolARNs() {
        return poolARNs != null && !(poolARNs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a custom
     * tape pool ARN, the response lists all custom tape pools.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPoolARNs} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a
     *         custom tape pool ARN, the response lists all custom tape pools.
     */
    public final List<String> poolARNs() {
        return poolARNs;
    }

    /**
     * <p>
     * A string that indicates the position at which to begin the returned list of tape pools.
     * </p>
     * 
     * @return A string that indicates the position at which to begin the returned list of tape pools.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * An optional number limit for the tape pools in the list returned by this call.
     * </p>
     * 
     * @return An optional number limit for the tape pools in the list returned by this call.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolARNs() ? poolARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTapePoolsRequest)) {
            return false;
        }
        ListTapePoolsRequest other = (ListTapePoolsRequest) obj;
        return hasPoolARNs() == other.hasPoolARNs() && Objects.equals(poolARNs(), other.poolARNs())
                && Objects.equals(marker(), other.marker()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTapePoolsRequest").add("PoolARNs", hasPoolARNs() ? poolARNs() : null)
                .add("Marker", marker()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolARNs":
            return Optional.ofNullable(clazz.cast(poolARNs()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolARNs", POOL_AR_NS_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTapePoolsRequest, T> g) {
        return obj -> g.apply((ListTapePoolsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTapePoolsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a
         * custom tape pool ARN, the response lists all custom tape pools.
         * </p>
         * 
         * @param poolARNs
         *        The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify
         *        a custom tape pool ARN, the response lists all custom tape pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolARNs(Collection<String> poolARNs);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify a
         * custom tape pool ARN, the response lists all custom tape pools.
         * </p>
         * 
         * @param poolARNs
         *        The Amazon Resource Name (ARN) of each of the custom tape pools you want to list. If you don't specify
         *        a custom tape pool ARN, the response lists all custom tape pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolARNs(String... poolARNs);

        /**
         * <p>
         * A string that indicates the position at which to begin the returned list of tape pools.
         * </p>
         * 
         * @param marker
         *        A string that indicates the position at which to begin the returned list of tape pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An optional number limit for the tape pools in the list returned by this call.
         * </p>
         * 
         * @param limit
         *        An optional number limit for the tape pools in the list returned by this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private List<String> poolARNs = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTapePoolsRequest model) {
            super(model);
            poolARNs(model.poolARNs);
            marker(model.marker);
            limit(model.limit);
        }

        public final Collection<String> getPoolARNs() {
            if (poolARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return poolARNs;
        }

        public final void setPoolARNs(Collection<String> poolARNs) {
            this.poolARNs = PoolARNsCopier.copy(poolARNs);
        }

        @Override
        public final Builder poolARNs(Collection<String> poolARNs) {
            this.poolARNs = PoolARNsCopier.copy(poolARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolARNs(String... poolARNs) {
            poolARNs(Arrays.asList(poolARNs));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTapePoolsRequest build() {
            return new ListTapePoolsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
