/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListVolumeInitiatorsOutput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVolumeInitiatorsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<ListVolumeInitiatorsResponse.Builder, ListVolumeInitiatorsResponse> {
    private static final SdkField<List<String>> INITIATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Initiators")
            .getter(getter(ListVolumeInitiatorsResponse::initiators))
            .setter(setter(Builder::initiators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIATORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> initiators;

    private ListVolumeInitiatorsResponse(BuilderImpl builder) {
        super(builder);
        this.initiators = builder.initiators;
    }

    /**
     * For responses, this returns true if the service returned a value for the Initiators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInitiators() {
        return initiators != null && !(initiators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInitiators} method.
     * </p>
     * 
     * @return The host names and port numbers of all iSCSI initiators that are connected to the gateway.
     */
    public final List<String> initiators() {
        return initiators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInitiators() ? initiators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumeInitiatorsResponse)) {
            return false;
        }
        ListVolumeInitiatorsResponse other = (ListVolumeInitiatorsResponse) obj;
        return hasInitiators() == other.hasInitiators() && Objects.equals(initiators(), other.initiators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVolumeInitiatorsResponse").add("Initiators", hasInitiators() ? initiators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Initiators":
            return Optional.ofNullable(clazz.cast(initiators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Initiators", INITIATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVolumeInitiatorsResponse, T> g) {
        return obj -> g.apply((ListVolumeInitiatorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
        /**
         * <p>
         * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * </p>
         * 
         * @param initiators
         *        The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiators(Collection<String> initiators);

        /**
         * <p>
         * The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * </p>
         * 
         * @param initiators
         *        The host names and port numbers of all iSCSI initiators that are connected to the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiators(String... initiators);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<String> initiators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumeInitiatorsResponse model) {
            super(model);
            initiators(model.initiators);
        }

        public final Collection<String> getInitiators() {
            if (initiators instanceof SdkAutoConstructList) {
                return null;
            }
            return initiators;
        }

        public final void setInitiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
        }

        @Override
        public final Builder initiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiators(String... initiators) {
            initiators(Arrays.asList(initiators));
            return this;
        }

        @Override
        public ListVolumeInitiatorsResponse build() {
            return new ListVolumeInitiatorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
