/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateNFSFileShareInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNfsFileShareRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateNfsFileShareRequest.Builder, UpdateNfsFileShareRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareARN").getter(getter(UpdateNfsFileShareRequest::fileShareARN))
            .setter(setter(Builder::fileShareARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(UpdateNfsFileShareRequest::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KMSEncrypted").getter(getter(UpdateNfsFileShareRequest::kmsEncrypted))
            .setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KMSKey")
            .getter(getter(UpdateNfsFileShareRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField
            .<NFSFileShareDefaults> builder(MarshallingType.SDK_POJO).memberName("NFSFileShareDefaults")
            .getter(getter(UpdateNfsFileShareRequest::nfsFileShareDefaults)).setter(setter(Builder::nfsFileShareDefaults))
            .constructor(NFSFileShareDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build())
            .build();

    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultStorageClass").getter(getter(UpdateNfsFileShareRequest::defaultStorageClass))
            .setter(setter(Builder::defaultStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build())
            .build();

    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectACL").getter(getter(UpdateNfsFileShareRequest::objectACLAsString))
            .setter(setter(Builder::objectACL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()).build();

    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClientList")
            .getter(getter(UpdateNfsFileShareRequest::clientList))
            .setter(setter(Builder::clientList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SQUASH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Squash")
            .getter(getter(UpdateNfsFileShareRequest::squash)).setter(setter(Builder::squash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()).build();

    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadOnly").getter(getter(UpdateNfsFileShareRequest::readOnly)).setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GuessMIMETypeEnabled").getter(getter(UpdateNfsFileShareRequest::guessMIMETypeEnabled))
            .setter(setter(Builder::guessMIMETypeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build())
            .build();

    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterPays").getter(getter(UpdateNfsFileShareRequest::requesterPays))
            .setter(setter(Builder::requesterPays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()).build();

    private static final SdkField<String> FILE_SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileShareName").getter(getter(UpdateNfsFileShareRequest::fileShareName))
            .setter(setter(Builder::fileShareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareName").build()).build();

    private static final SdkField<CacheAttributes> CACHE_ATTRIBUTES_FIELD = SdkField
            .<CacheAttributes> builder(MarshallingType.SDK_POJO).memberName("CacheAttributes")
            .getter(getter(UpdateNfsFileShareRequest::cacheAttributes)).setter(setter(Builder::cacheAttributes))
            .constructor(CacheAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheAttributes").build()).build();

    private static final SdkField<String> NOTIFICATION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationPolicy").getter(getter(UpdateNfsFileShareRequest::notificationPolicy))
            .setter(setter(Builder::notificationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationPolicy").build())
            .build();

    private static final SdkField<String> AUDIT_DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditDestinationARN").getter(getter(UpdateNfsFileShareRequest::auditDestinationARN))
            .setter(setter(Builder::auditDestinationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditDestinationARN").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD,
            ENCRYPTION_TYPE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, NFS_FILE_SHARE_DEFAULTS_FIELD,
            DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD,
            GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, FILE_SHARE_NAME_FIELD, CACHE_ATTRIBUTES_FIELD,
            NOTIFICATION_POLICY_FIELD, AUDIT_DESTINATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileShareARN;

    private final String encryptionType;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final NFSFileShareDefaults nfsFileShareDefaults;

    private final String defaultStorageClass;

    private final String objectACL;

    private final List<String> clientList;

    private final String squash;

    private final Boolean readOnly;

    private final Boolean guessMIMETypeEnabled;

    private final Boolean requesterPays;

    private final String fileShareName;

    private final CacheAttributes cacheAttributes;

    private final String notificationPolicy;

    private final String auditDestinationARN;

    private UpdateNfsFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.encryptionType = builder.encryptionType;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.fileShareName = builder.fileShareName;
        this.cacheAttributes = builder.cacheAttributes;
        this.notificationPolicy = builder.notificationPolicy;
        this.auditDestinationARN = builder.auditDestinationARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the file share to be updated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the file share to be updated.
     */
    public final String fileShareARN() {
        return fileShareARN;
    }

    /**
     * <p>
     * A value that specifies the type of server-side encryption that the file share will use for the data that it
     * stores in Amazon S3.
     * </p>
     * <note>
     * <p>
     * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     * encryption method. You do not need to provide values for both parameters.
     * </p>
     * <p>
     * If values for both parameters exist in the same request, then the specified encryption methods must not conflict.
     * For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code> must be
     * <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>, then
     * <code>KMSEncrypted</code> must be <code>true</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return A value that specifies the type of server-side encryption that the file share will use for the data that
     *         it stores in Amazon S3.</p> <note>
     *         <p>
     *         We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     *         encryption method. You do not need to provide values for both parameters.
     *         </p>
     *         <p>
     *         If values for both parameters exist in the same request, then the specified encryption methods must not
     *         conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
     *         <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
     *         <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
     *         </p>
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * A value that specifies the type of server-side encryption that the file share will use for the data that it
     * stores in Amazon S3.
     * </p>
     * <note>
     * <p>
     * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     * encryption method. You do not need to provide values for both parameters.
     * </p>
     * <p>
     * If values for both parameters exist in the same request, then the specified encryption methods must not conflict.
     * For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code> must be
     * <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>, then
     * <code>KMSEncrypted</code> must be <code>true</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return A value that specifies the type of server-side encryption that the file share will use for the data that
     *         it stores in Amazon S3.</p> <note>
     *         <p>
     *         We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     *         encryption method. You do not need to provide values for both parameters.
     *         </p>
     *         <p>
     *         If values for both parameters exist in the same request, then the specified encryption methods must not
     *         conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
     *         <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
     *         <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
     *         </p>
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * <p>
     * Optional. Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key (SSE-KMS), or
     * <code>false</code> to use a key managed by Amazon S3 (SSE-S3). To use dual-layer encryption (DSSE-KMS), set the
     * <code>EncryptionType</code> parameter instead.
     * </p>
     * <note>
     * <p>
     * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     * encryption method. You do not need to provide values for both parameters.
     * </p>
     * <p>
     * If values for both parameters exist in the same request, then the specified encryption methods must not conflict.
     * For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code> must be
     * <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>, then
     * <code>KMSEncrypted</code> must be <code>true</code>.
     * </p>
     * </note>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return Optional. Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key
     *         (SSE-KMS), or <code>false</code> to use a key managed by Amazon S3 (SSE-S3). To use dual-layer encryption
     *         (DSSE-KMS), set the <code>EncryptionType</code> parameter instead.</p> <note>
     *         <p>
     *         We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
     *         encryption method. You do not need to provide values for both parameters.
     *         </p>
     *         <p>
     *         If values for both parameters exist in the same request, then the specified encryption methods must not
     *         conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
     *         <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
     *         <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     * @deprecated KMSEncrypted is deprecated, use EncryptionType instead.
     */
    @Deprecated
    public final Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side
     * encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if <code>KMSEncrypted</code>
     * is <code>true</code>, or if <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>.
     * </p>
     * 
     * @return Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3
     *         server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if
     *         <code>KMSEncrypted</code> is <code>true</code>, or if <code>EncryptionType</code> is <code>SseKms</code>
     *         or <code>DsseKms</code>.
     */
    public final String kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The default values for the file share. Optional.
     * </p>
     * 
     * @return The default values for the file share. Optional.
     */
    public final NFSFileShareDefaults nfsFileShareDefaults() {
        return nfsFileShareDefaults;
    }

    /**
     * <p>
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value is
     * <code>S3_STANDARD</code>. Optional.
     * </p>
     * <p>
     * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
     * <code>S3_ONEZONE_IA</code>
     * </p>
     * 
     * @return The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default
     *         value is <code>S3_STANDARD</code>. Optional.</p>
     *         <p>
     *         Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
     *         <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
     */
    public final String defaultStorageClass() {
        return defaultStorageClass;
    }

    /**
     * <p>
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway
     * puts objects into. The default value is <code>private</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
     *         Gateway puts objects into. The default value is <code>private</code>.
     * @see ObjectACL
     */
    public final ObjectACL objectACL() {
        return ObjectACL.fromValue(objectACL);
    }

    /**
     * <p>
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File Gateway
     * puts objects into. The default value is <code>private</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectACL} will
     * return {@link ObjectACL#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectACLAsString}.
     * </p>
     * 
     * @return A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
     *         Gateway puts objects into. The default value is <code>private</code>.
     * @see ObjectACL
     */
    public final String objectACLAsString() {
        return objectACL;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClientList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClientList() {
        return clientList != null && !(clientList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid IPv4/IPv6
     * addresses or valid CIDR blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClientList} method.
     * </p>
     * 
     * @return The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid
     *         IPv4/IPv6 addresses or valid CIDR blocks.
     */
    public final List<String> clientList() {
        return clientList;
    }

    /**
     * <p>
     * The user mapped to anonymous user.
     * </p>
     * <p>
     * Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RootSquash</code>: Only root is mapped to anonymous user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NoSquash</code>: No one is mapped to anonymous user.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AllSquash</code>: Everyone is mapped to anonymous user.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The user mapped to anonymous user.</p>
     *         <p>
     *         Valid values are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RootSquash</code>: Only root is mapped to anonymous user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NoSquash</code>: No one is mapped to anonymous user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AllSquash</code>: Everyone is mapped to anonymous user.
     *         </p>
     *         </li>
     */
    public final String squash() {
        return squash;
    }

    /**
     * <p>
     * A value that sets the write status of a file share. Set this value to <code>true</code> to set the write status
     * to read-only, otherwise set to <code>false</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets the write status of a file share. Set this value to <code>true</code> to set the write
     *         status to read-only, otherwise set to <code>false</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value to
     * <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
     * <code>true</code>.
     * </p>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
     *         value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default
     *         value is <code>true</code>.</p>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean guessMIMETypeEnabled() {
        return guessMIMETypeEnabled;
    }

    /**
     * <p>
     * A value that sets who pays the cost of the request and the cost associated with data download from the S3 bucket.
     * If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket owner pays.
     * However, the S3 bucket owner always pays the cost of storing data.
     * </p>
     * <note>
     * <p>
     * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that the
     * configuration on the file share is the same as the S3 bucket configuration.
     * </p>
     * </note>
     * <p>
     * Valid Values: <code>true</code> | <code>false</code>
     * </p>
     * 
     * @return A value that sets who pays the cost of the request and the cost associated with data download from the S3
     *         bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
     *         owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
     *         <p>
     *         <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure
     *         that the configuration on the file share is the same as the S3 bucket configuration.
     *         </p>
     *         </note>
     *         <p>
     *         Valid Values: <code>true</code> | <code>false</code>
     */
    public final Boolean requesterPays() {
        return requesterPays;
    }

    /**
     * <p>
     * The name of the file share. Optional.
     * </p>
     * <note>
     * <p>
     * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an access
     * point or access point alias is used.
     * </p>
     * <p>
     * A valid NFS file share name can only contain the following characters: <code>a</code>-<code>z</code>,
     * <code>A</code>-<code>Z</code>, <code>0</code>-<code>9</code>, <code>-</code>, <code>.</code>, and <code>_</code>.
     * </p>
     * </note>
     * 
     * @return The name of the file share. Optional.</p> <note>
     *         <p>
     *         <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an
     *         access point or access point alias is used.
     *         </p>
     *         <p>
     *         A valid NFS file share name can only contain the following characters: <code>a</code>-<code>z</code>,
     *         <code>A</code>-<code>Z</code>, <code>0</code>-<code>9</code>, <code>-</code>, <code>.</code>, and
     *         <code>_</code>.
     *         </p>
     */
    public final String fileShareName() {
        return fileShareName;
    }

    /**
     * <p>
     * Specifies refresh cache information for the file share.
     * </p>
     * 
     * @return Specifies refresh cache information for the file share.
     */
    public final CacheAttributes cacheAttributes() {
        return cacheAttributes;
    }

    /**
     * <p>
     * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds to
     * wait after the last point in time a client wrote to a file before generating an <code>ObjectUploaded</code>
     * notification. Because clients can make many small writes to files, it's best to set this parameter for as long as
     * possible to avoid generating multiple notifications for the same file in a small time period.
     * </p>
     * <note>
     * <p>
     * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
     * timing of the notification.
     * </p>
     * <p>
     * This setting is not meant to specify an exact time at which the notification will be sent. In some cases, the
     * gateway might require more than the specified delay time to generate and send notifications.
     * </p>
     * </note>
     * <p>
     * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to 60.
     * </p>
     * <p>
     * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     * </p>
     * <p>
     * The following example sets <code>NotificationPolicy</code> off.
     * </p>
     * <p>
     * <code>{}</code>
     * </p>
     * 
     * @return The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
     *         seconds to wait after the last point in time a client wrote to a file before generating an
     *         <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best
     *         to set this parameter for as long as possible to avoid generating multiple notifications for the same
     *         file in a small time period.</p> <note>
     *         <p>
     *         <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only
     *         the timing of the notification.
     *         </p>
     *         <p>
     *         This setting is not meant to specify an exact time at which the notification will be sent. In some cases,
     *         the gateway might require more than the specified delay time to generate and send notifications.
     *         </p>
     *         </note>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set
     *         to 60.
     *         </p>
     *         <p>
     *         <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
     *         </p>
     *         <p>
     *         The following example sets <code>NotificationPolicy</code> off.
     *         </p>
     *         <p>
     *         <code>{}</code>
     */
    public final String notificationPolicy() {
        return notificationPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    public final String auditDestinationARN() {
        return auditDestinationARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasClientList() ? clientList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(squash());
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(fileShareName());
        hashCode = 31 * hashCode + Objects.hashCode(cacheAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(notificationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(auditDestinationARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNfsFileShareRequest)) {
            return false;
        }
        UpdateNfsFileShareRequest other = (UpdateNfsFileShareRequest) obj;
        return Objects.equals(fileShareARN(), other.fileShareARN())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(nfsFileShareDefaults(), other.nfsFileShareDefaults())
                && Objects.equals(defaultStorageClass(), other.defaultStorageClass())
                && Objects.equals(objectACLAsString(), other.objectACLAsString()) && hasClientList() == other.hasClientList()
                && Objects.equals(clientList(), other.clientList()) && Objects.equals(squash(), other.squash())
                && Objects.equals(readOnly(), other.readOnly())
                && Objects.equals(guessMIMETypeEnabled(), other.guessMIMETypeEnabled())
                && Objects.equals(requesterPays(), other.requesterPays())
                && Objects.equals(fileShareName(), other.fileShareName())
                && Objects.equals(cacheAttributes(), other.cacheAttributes())
                && Objects.equals(notificationPolicy(), other.notificationPolicy())
                && Objects.equals(auditDestinationARN(), other.auditDestinationARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNfsFileShareRequest").add("FileShareARN", fileShareARN())
                .add("EncryptionType", encryptionTypeAsString()).add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey())
                .add("NFSFileShareDefaults", nfsFileShareDefaults()).add("DefaultStorageClass", defaultStorageClass())
                .add("ObjectACL", objectACLAsString()).add("ClientList", hasClientList() ? clientList() : null)
                .add("Squash", squash()).add("ReadOnly", readOnly()).add("GuessMIMETypeEnabled", guessMIMETypeEnabled())
                .add("RequesterPays", requesterPays()).add("FileShareName", fileShareName())
                .add("CacheAttributes", cacheAttributes()).add("NotificationPolicy", notificationPolicy())
                .add("AuditDestinationARN", auditDestinationARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileShareARN":
            return Optional.ofNullable(clazz.cast(fileShareARN()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "NFSFileShareDefaults":
            return Optional.ofNullable(clazz.cast(nfsFileShareDefaults()));
        case "DefaultStorageClass":
            return Optional.ofNullable(clazz.cast(defaultStorageClass()));
        case "ObjectACL":
            return Optional.ofNullable(clazz.cast(objectACLAsString()));
        case "ClientList":
            return Optional.ofNullable(clazz.cast(clientList()));
        case "Squash":
            return Optional.ofNullable(clazz.cast(squash()));
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "GuessMIMETypeEnabled":
            return Optional.ofNullable(clazz.cast(guessMIMETypeEnabled()));
        case "RequesterPays":
            return Optional.ofNullable(clazz.cast(requesterPays()));
        case "FileShareName":
            return Optional.ofNullable(clazz.cast(fileShareName()));
        case "CacheAttributes":
            return Optional.ofNullable(clazz.cast(cacheAttributes()));
        case "NotificationPolicy":
            return Optional.ofNullable(clazz.cast(notificationPolicy()));
        case "AuditDestinationARN":
            return Optional.ofNullable(clazz.cast(auditDestinationARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("KMSEncrypted", KMS_ENCRYPTED_FIELD);
        map.put("KMSKey", KMS_KEY_FIELD);
        map.put("NFSFileShareDefaults", NFS_FILE_SHARE_DEFAULTS_FIELD);
        map.put("DefaultStorageClass", DEFAULT_STORAGE_CLASS_FIELD);
        map.put("ObjectACL", OBJECT_ACL_FIELD);
        map.put("ClientList", CLIENT_LIST_FIELD);
        map.put("Squash", SQUASH_FIELD);
        map.put("ReadOnly", READ_ONLY_FIELD);
        map.put("GuessMIMETypeEnabled", GUESS_MIME_TYPE_ENABLED_FIELD);
        map.put("RequesterPays", REQUESTER_PAYS_FIELD);
        map.put("FileShareName", FILE_SHARE_NAME_FIELD);
        map.put("CacheAttributes", CACHE_ATTRIBUTES_FIELD);
        map.put("NotificationPolicy", NOTIFICATION_POLICY_FIELD);
        map.put("AuditDestinationARN", AUDIT_DESTINATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNfsFileShareRequest, T> g) {
        return obj -> g.apply((UpdateNfsFileShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNfsFileShareRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the file share to be updated.
         * </p>
         * 
         * @param fileShareARN
         *        The Amazon Resource Name (ARN) of the file share to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareARN(String fileShareARN);

        /**
         * <p>
         * A value that specifies the type of server-side encryption that the file share will use for the data that it
         * stores in Amazon S3.
         * </p>
         * <note>
         * <p>
         * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
         * encryption method. You do not need to provide values for both parameters.
         * </p>
         * <p>
         * If values for both parameters exist in the same request, then the specified encryption methods must not
         * conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code>
         * must be <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>,
         * then <code>KMSEncrypted</code> must be <code>true</code>.
         * </p>
         * </note>
         * 
         * @param encryptionType
         *        A value that specifies the type of server-side encryption that the file share will use for the data
         *        that it stores in Amazon S3.</p> <note>
         *        <p>
         *        We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file
         *        share encryption method. You do not need to provide values for both parameters.
         *        </p>
         *        <p>
         *        If values for both parameters exist in the same request, then the specified encryption methods must
         *        not conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
         *        <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
         *        <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
         *        </p>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * A value that specifies the type of server-side encryption that the file share will use for the data that it
         * stores in Amazon S3.
         * </p>
         * <note>
         * <p>
         * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
         * encryption method. You do not need to provide values for both parameters.
         * </p>
         * <p>
         * If values for both parameters exist in the same request, then the specified encryption methods must not
         * conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code>
         * must be <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>,
         * then <code>KMSEncrypted</code> must be <code>true</code>.
         * </p>
         * </note>
         * 
         * @param encryptionType
         *        A value that specifies the type of server-side encryption that the file share will use for the data
         *        that it stores in Amazon S3.</p> <note>
         *        <p>
         *        We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file
         *        share encryption method. You do not need to provide values for both parameters.
         *        </p>
         *        <p>
         *        If values for both parameters exist in the same request, then the specified encryption methods must
         *        not conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
         *        <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
         *        <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
         *        </p>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);

        /**
         * <p>
         * Optional. Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key (SSE-KMS),
         * or <code>false</code> to use a key managed by Amazon S3 (SSE-S3). To use dual-layer encryption (DSSE-KMS),
         * set the <code>EncryptionType</code> parameter instead.
         * </p>
         * <note>
         * <p>
         * We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file share
         * encryption method. You do not need to provide values for both parameters.
         * </p>
         * <p>
         * If values for both parameters exist in the same request, then the specified encryption methods must not
         * conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then <code>KMSEncrypted</code>
         * must be <code>false</code>. If <code>EncryptionType</code> is <code>SseKms</code> or <code>DsseKms</code>,
         * then <code>KMSEncrypted</code> must be <code>true</code>.
         * </p>
         * </note>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param kmsEncrypted
         *        Optional. Set to <code>true</code> to use Amazon S3 server-side encryption with your own KMS key
         *        (SSE-KMS), or <code>false</code> to use a key managed by Amazon S3 (SSE-S3). To use dual-layer
         *        encryption (DSSE-KMS), set the <code>EncryptionType</code> parameter instead.</p> <note>
         *        <p>
         *        We recommend using <code>EncryptionType</code> instead of <code>KMSEncrypted</code> to set the file
         *        share encryption method. You do not need to provide values for both parameters.
         *        </p>
         *        <p>
         *        If values for both parameters exist in the same request, then the specified encryption methods must
         *        not conflict. For example, if <code>EncryptionType</code> is <code>SseS3</code>, then
         *        <code>KMSEncrypted</code> must be <code>false</code>. If <code>EncryptionType</code> is
         *        <code>SseKms</code> or <code>DsseKms</code>, then <code>KMSEncrypted</code> must be <code>true</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated KMSEncrypted is deprecated, use EncryptionType instead.
         */
        @Deprecated
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3
         * server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if
         * <code>KMSEncrypted</code> is <code>true</code>, or if <code>EncryptionType</code> is <code>SseKms</code> or
         * <code>DsseKms</code>.
         * </p>
         * 
         * @param kmsKey
         *        Optional. The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3
         *        server-side encryption. Storage Gateway does not support asymmetric CMKs. This value must be set if
         *        <code>KMSEncrypted</code> is <code>true</code>, or if <code>EncryptionType</code> is
         *        <code>SseKms</code> or <code>DsseKms</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * The default values for the file share. Optional.
         * </p>
         * 
         * @param nfsFileShareDefaults
         *        The default values for the file share. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults);

        /**
         * <p>
         * The default values for the file share. Optional.
         * </p>
         * This is a convenience method that creates an instance of the {@link NFSFileShareDefaults.Builder} avoiding
         * the need to create one manually via {@link NFSFileShareDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NFSFileShareDefaults.Builder#build()} is called immediately and
         * its result is passed to {@link #nfsFileShareDefaults(NFSFileShareDefaults)}.
         * 
         * @param nfsFileShareDefaults
         *        a consumer that will call methods on {@link NFSFileShareDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nfsFileShareDefaults(NFSFileShareDefaults)
         */
        default Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return nfsFileShareDefaults(NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults).build());
        }

        /**
         * <p>
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default value
         * is <code>S3_STANDARD</code>. Optional.
         * </p>
         * <p>
         * Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> | <code>S3_STANDARD_IA</code> |
         * <code>S3_ONEZONE_IA</code>
         * </p>
         * 
         * @param defaultStorageClass
         *        The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway. The default
         *        value is <code>S3_STANDARD</code>. Optional.</p>
         *        <p>
         *        Valid Values: <code>S3_STANDARD</code> | <code>S3_INTELLIGENT_TIERING</code> |
         *        <code>S3_STANDARD_IA</code> | <code>S3_ONEZONE_IA</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultStorageClass(String defaultStorageClass);

        /**
         * <p>
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
         * Gateway puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
         *        Gateway puts objects into. The default value is <code>private</code>.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(String objectACL);

        /**
         * <p>
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
         * Gateway puts objects into. The default value is <code>private</code>.
         * </p>
         * 
         * @param objectACL
         *        A value that sets the access control list (ACL) permission for objects in the S3 bucket that a S3 File
         *        Gateway puts objects into. The default value is <code>private</code>.
         * @see ObjectACL
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectACL
         */
        Builder objectACL(ObjectACL objectACL);

        /**
         * <p>
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid
         * IPv4/IPv6 addresses or valid CIDR blocks.
         * </p>
         * 
         * @param clientList
         *        The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid
         *        IPv4/IPv6 addresses or valid CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(Collection<String> clientList);

        /**
         * <p>
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid
         * IPv4/IPv6 addresses or valid CIDR blocks.
         * </p>
         * 
         * @param clientList
         *        The list of clients that are allowed to access the S3 File Gateway. The list must contain either valid
         *        IPv4/IPv6 addresses or valid CIDR blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientList(String... clientList);

        /**
         * <p>
         * The user mapped to anonymous user.
         * </p>
         * <p>
         * Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RootSquash</code>: Only root is mapped to anonymous user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NoSquash</code>: No one is mapped to anonymous user.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AllSquash</code>: Everyone is mapped to anonymous user.
         * </p>
         * </li>
         * </ul>
         * 
         * @param squash
         *        The user mapped to anonymous user.</p>
         *        <p>
         *        Valid values are the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RootSquash</code>: Only root is mapped to anonymous user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NoSquash</code>: No one is mapped to anonymous user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AllSquash</code>: Everyone is mapped to anonymous user.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder squash(String squash);

        /**
         * <p>
         * A value that sets the write status of a file share. Set this value to <code>true</code> to set the write
         * status to read-only, otherwise set to <code>false</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param readOnly
         *        A value that sets the write status of a file share. Set this value to <code>true</code> to set the
         *        write status to read-only, otherwise set to <code>false</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this value
         * to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The default value is
         * <code>true</code>.
         * </p>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param guessMIMETypeEnabled
         *        A value that enables guessing of the MIME type for uploaded objects based on file extensions. Set this
         *        value to <code>true</code> to enable MIME type guessing, otherwise set to <code>false</code>. The
         *        default value is <code>true</code>.</p>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled);

        /**
         * <p>
         * A value that sets who pays the cost of the request and the cost associated with data download from the S3
         * bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3 bucket
         * owner pays. However, the S3 bucket owner always pays the cost of storing data.
         * </p>
         * <note>
         * <p>
         * <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make sure that
         * the configuration on the file share is the same as the S3 bucket configuration.
         * </p>
         * </note>
         * <p>
         * Valid Values: <code>true</code> | <code>false</code>
         * </p>
         * 
         * @param requesterPays
         *        A value that sets who pays the cost of the request and the cost associated with data download from the
         *        S3 bucket. If this value is set to <code>true</code>, the requester pays the costs; otherwise, the S3
         *        bucket owner pays. However, the S3 bucket owner always pays the cost of storing data.</p> <note>
         *        <p>
         *        <code>RequesterPays</code> is a configuration for the S3 bucket that backs the file share, so make
         *        sure that the configuration on the file share is the same as the S3 bucket configuration.
         *        </p>
         *        </note>
         *        <p>
         *        Valid Values: <code>true</code> | <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPays(Boolean requesterPays);

        /**
         * <p>
         * The name of the file share. Optional.
         * </p>
         * <note>
         * <p>
         * <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if an
         * access point or access point alias is used.
         * </p>
         * <p>
         * A valid NFS file share name can only contain the following characters: <code>a</code>-<code>z</code>,
         * <code>A</code>-<code>Z</code>, <code>0</code>-<code>9</code>, <code>-</code>, <code>.</code>, and
         * <code>_</code>.
         * </p>
         * </note>
         * 
         * @param fileShareName
         *        The name of the file share. Optional.</p> <note>
         *        <p>
         *        <code>FileShareName</code> must be set if an S3 prefix name is set in <code>LocationARN</code>, or if
         *        an access point or access point alias is used.
         *        </p>
         *        <p>
         *        A valid NFS file share name can only contain the following characters: <code>a</code>-<code>z</code>,
         *        <code>A</code>-<code>Z</code>, <code>0</code>-<code>9</code>, <code>-</code>, <code>.</code>, and
         *        <code>_</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileShareName(String fileShareName);

        /**
         * <p>
         * Specifies refresh cache information for the file share.
         * </p>
         * 
         * @param cacheAttributes
         *        Specifies refresh cache information for the file share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheAttributes(CacheAttributes cacheAttributes);

        /**
         * <p>
         * Specifies refresh cache information for the file share.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheAttributes.Builder} avoiding the
         * need to create one manually via {@link CacheAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheAttributes(CacheAttributes)}.
         * 
         * @param cacheAttributes
         *        a consumer that will call methods on {@link CacheAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheAttributes(CacheAttributes)
         */
        default Builder cacheAttributes(Consumer<CacheAttributes.Builder> cacheAttributes) {
            return cacheAttributes(CacheAttributes.builder().applyMutation(cacheAttributes).build());
        }

        /**
         * <p>
         * The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of seconds
         * to wait after the last point in time a client wrote to a file before generating an
         * <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's best to
         * set this parameter for as long as possible to avoid generating multiple notifications for the same file in a
         * small time period.
         * </p>
         * <note>
         * <p>
         * <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3, only the
         * timing of the notification.
         * </p>
         * <p>
         * This setting is not meant to specify an exact time at which the notification will be sent. In some cases, the
         * gateway might require more than the specified delay time to generate and send notifications.
         * </p>
         * </note>
         * <p>
         * The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code> set to
         * 60.
         * </p>
         * <p>
         * <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         * </p>
         * <p>
         * The following example sets <code>NotificationPolicy</code> off.
         * </p>
         * <p>
         * <code>{}</code>
         * </p>
         * 
         * @param notificationPolicy
         *        The notification policy of the file share. <code>SettlingTimeInSeconds</code> controls the number of
         *        seconds to wait after the last point in time a client wrote to a file before generating an
         *        <code>ObjectUploaded</code> notification. Because clients can make many small writes to files, it's
         *        best to set this parameter for as long as possible to avoid generating multiple notifications for the
         *        same file in a small time period.</p> <note>
         *        <p>
         *        <code>SettlingTimeInSeconds</code> has no effect on the timing of the object uploading to Amazon S3,
         *        only the timing of the notification.
         *        </p>
         *        <p>
         *        This setting is not meant to specify an exact time at which the notification will be sent. In some
         *        cases, the gateway might require more than the specified delay time to generate and send
         *        notifications.
         *        </p>
         *        </note>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> on with <code>SettlingTimeInSeconds</code>
         *        set to 60.
         *        </p>
         *        <p>
         *        <code>{\"Upload\": {\"SettlingTimeInSeconds\": 60}}</code>
         *        </p>
         *        <p>
         *        The following example sets <code>NotificationPolicy</code> off.
         *        </p>
         *        <p>
         *        <code>{}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationPolicy(String notificationPolicy);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         * </p>
         * 
         * @param auditDestinationARN
         *        The Amazon Resource Name (ARN) of the storage used for audit logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditDestinationARN(String auditDestinationARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String fileShareARN;

        private String encryptionType;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private NFSFileShareDefaults nfsFileShareDefaults;

        private String defaultStorageClass;

        private String objectACL;

        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();

        private String squash;

        private Boolean readOnly;

        private Boolean guessMIMETypeEnabled;

        private Boolean requesterPays;

        private String fileShareName;

        private CacheAttributes cacheAttributes;

        private String notificationPolicy;

        private String auditDestinationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNfsFileShareRequest model) {
            super(model);
            fileShareARN(model.fileShareARN);
            encryptionType(model.encryptionType);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            nfsFileShareDefaults(model.nfsFileShareDefaults);
            defaultStorageClass(model.defaultStorageClass);
            objectACL(model.objectACL);
            clientList(model.clientList);
            squash(model.squash);
            readOnly(model.readOnly);
            guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            requesterPays(model.requesterPays);
            fileShareName(model.fileShareName);
            cacheAttributes(model.cacheAttributes);
            notificationPolicy(model.notificationPolicy);
            auditDestinationARN(model.auditDestinationARN);
        }

        public final String getFileShareARN() {
            return fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Deprecated
        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Deprecated
        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        @Override
        @Deprecated
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return nfsFileShareDefaults != null ? nfsFileShareDefaults.toBuilder() : null;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final String getDefaultStorageClass() {
            return defaultStorageClass;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final String getObjectACL() {
            return objectACL;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL == null ? null : objectACL.toString());
            return this;
        }

        public final Collection<String> getClientList() {
            if (clientList instanceof SdkAutoConstructList) {
                return null;
            }
            return clientList;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String... clientList) {
            clientList(Arrays.asList(clientList));
            return this;
        }

        public final String getSquash() {
            return squash;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return guessMIMETypeEnabled;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final Boolean getRequesterPays() {
            return requesterPays;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final String getFileShareName() {
            return fileShareName;
        }

        public final void setFileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
        }

        @Override
        public final Builder fileShareName(String fileShareName) {
            this.fileShareName = fileShareName;
            return this;
        }

        public final CacheAttributes.Builder getCacheAttributes() {
            return cacheAttributes != null ? cacheAttributes.toBuilder() : null;
        }

        public final void setCacheAttributes(CacheAttributes.BuilderImpl cacheAttributes) {
            this.cacheAttributes = cacheAttributes != null ? cacheAttributes.build() : null;
        }

        @Override
        public final Builder cacheAttributes(CacheAttributes cacheAttributes) {
            this.cacheAttributes = cacheAttributes;
            return this;
        }

        public final String getNotificationPolicy() {
            return notificationPolicy;
        }

        public final void setNotificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
        }

        @Override
        public final Builder notificationPolicy(String notificationPolicy) {
            this.notificationPolicy = notificationPolicy;
            return this;
        }

        public final String getAuditDestinationARN() {
            return auditDestinationARN;
        }

        public final void setAuditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
        }

        @Override
        public final Builder auditDestinationARN(String auditDestinationARN) {
            this.auditDestinationARN = auditDestinationARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNfsFileShareRequest build() {
            return new UpdateNfsFileShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
