/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSmbLocalGroupsRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateSmbLocalGroupsRequest.Builder, UpdateSmbLocalGroupsRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayARN").getter(getter(UpdateSmbLocalGroupsRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<SMBLocalGroups> SMB_LOCAL_GROUPS_FIELD = SdkField
            .<SMBLocalGroups> builder(MarshallingType.SDK_POJO).memberName("SMBLocalGroups")
            .getter(getter(UpdateSmbLocalGroupsRequest::smbLocalGroups)).setter(setter(Builder::smbLocalGroups))
            .constructor(SMBLocalGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMBLocalGroups").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            SMB_LOCAL_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayARN;

    private final SMBLocalGroups smbLocalGroups;

    private UpdateSmbLocalGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.smbLocalGroups = builder.smbLocalGroups;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public final String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on the
     * gateway.
     * </p>
     * 
     * @return A list of Active Directory users and groups that you want to grant special permissions for SMB file
     *         shares on the gateway.
     */
    public final SMBLocalGroups smbLocalGroups() {
        return smbLocalGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(smbLocalGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSmbLocalGroupsRequest)) {
            return false;
        }
        UpdateSmbLocalGroupsRequest other = (UpdateSmbLocalGroupsRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(smbLocalGroups(), other.smbLocalGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSmbLocalGroupsRequest").add("GatewayARN", gatewayARN())
                .add("SMBLocalGroups", smbLocalGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "SMBLocalGroups":
            return Optional.ofNullable(clazz.cast(smbLocalGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("SMBLocalGroups", SMB_LOCAL_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSmbLocalGroupsRequest, T> g) {
        return obj -> g.apply((UpdateSmbLocalGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSmbLocalGroupsRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on
         * the gateway.
         * </p>
         * 
         * @param smbLocalGroups
         *        A list of Active Directory users and groups that you want to grant special permissions for SMB file
         *        shares on the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smbLocalGroups(SMBLocalGroups smbLocalGroups);

        /**
         * <p>
         * A list of Active Directory users and groups that you want to grant special permissions for SMB file shares on
         * the gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link SMBLocalGroups.Builder} avoiding the need
         * to create one manually via {@link SMBLocalGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SMBLocalGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #smbLocalGroups(SMBLocalGroups)}.
         * 
         * @param smbLocalGroups
         *        a consumer that will call methods on {@link SMBLocalGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smbLocalGroups(SMBLocalGroups)
         */
        default Builder smbLocalGroups(Consumer<SMBLocalGroups.Builder> smbLocalGroups) {
            return smbLocalGroups(SMBLocalGroups.builder().applyMutation(smbLocalGroups).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private SMBLocalGroups smbLocalGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSmbLocalGroupsRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            smbLocalGroups(model.smbLocalGroups);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final SMBLocalGroups.Builder getSmbLocalGroups() {
            return smbLocalGroups != null ? smbLocalGroups.toBuilder() : null;
        }

        public final void setSmbLocalGroups(SMBLocalGroups.BuilderImpl smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups != null ? smbLocalGroups.build() : null;
        }

        @Override
        public final Builder smbLocalGroups(SMBLocalGroups smbLocalGroups) {
            this.smbLocalGroups = smbLocalGroups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSmbLocalGroupsRequest build() {
            return new UpdateSmbLocalGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
