/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a storage volume recovery point object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeRecoveryPointInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeRecoveryPointInfo.Builder, VolumeRecoveryPointInfo> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeARN").getter(getter(VolumeRecoveryPointInfo::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeSizeInBytes").getter(getter(VolumeRecoveryPointInfo::volumeSizeInBytes))
            .setter(setter(Builder::volumeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()).build();

    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeUsageInBytes").getter(getter(VolumeRecoveryPointInfo::volumeUsageInBytes))
            .setter(setter(Builder::volumeUsageInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build())
            .build();

    private static final SdkField<String> VOLUME_RECOVERY_POINT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeRecoveryPointTime").getter(getter(VolumeRecoveryPointInfo::volumeRecoveryPointTime))
            .setter(setter(Builder::volumeRecoveryPointTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeRecoveryPointTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            VOLUME_SIZE_IN_BYTES_FIELD, VOLUME_USAGE_IN_BYTES_FIELD, VOLUME_RECOVERY_POINT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String volumeARN;

    private final Long volumeSizeInBytes;

    private final Long volumeUsageInBytes;

    private final String volumeRecoveryPointTime;

    private VolumeRecoveryPointInfo(BuilderImpl builder) {
        this.volumeARN = builder.volumeARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeRecoveryPointTime = builder.volumeRecoveryPointTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume target.
     */
    public final String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The size of the volume in bytes.
     * </p>
     * 
     * @return The size of the volume in bytes.
     */
    public final Long volumeSizeInBytes() {
        return volumeSizeInBytes;
    }

    /**
     * <p>
     * The size of the data stored on the volume in bytes.
     * </p>
     * <note>
     * <p>
     * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
     * </p>
     * </note>
     * 
     * @return The size of the data stored on the volume in bytes.</p> <note>
     *         <p>
     *         This value is not available for volumes created prior to May 13, 2015, until you store data on the
     *         volume.
     *         </p>
     */
    public final Long volumeUsageInBytes() {
        return volumeUsageInBytes;
    }

    /**
     * <p>
     * The time the recovery point was taken.
     * </p>
     * 
     * @return The time the recovery point was taken.
     */
    public final String volumeRecoveryPointTime() {
        return volumeRecoveryPointTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeRecoveryPointTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecoveryPointInfo)) {
            return false;
        }
        VolumeRecoveryPointInfo other = (VolumeRecoveryPointInfo) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(volumeSizeInBytes(), other.volumeSizeInBytes())
                && Objects.equals(volumeUsageInBytes(), other.volumeUsageInBytes())
                && Objects.equals(volumeRecoveryPointTime(), other.volumeRecoveryPointTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeRecoveryPointInfo").add("VolumeARN", volumeARN())
                .add("VolumeSizeInBytes", volumeSizeInBytes()).add("VolumeUsageInBytes", volumeUsageInBytes())
                .add("VolumeRecoveryPointTime", volumeRecoveryPointTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "VolumeSizeInBytes":
            return Optional.ofNullable(clazz.cast(volumeSizeInBytes()));
        case "VolumeUsageInBytes":
            return Optional.ofNullable(clazz.cast(volumeUsageInBytes()));
        case "VolumeRecoveryPointTime":
            return Optional.ofNullable(clazz.cast(volumeRecoveryPointTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VolumeARN", VOLUME_ARN_FIELD);
        map.put("VolumeSizeInBytes", VOLUME_SIZE_IN_BYTES_FIELD);
        map.put("VolumeUsageInBytes", VOLUME_USAGE_IN_BYTES_FIELD);
        map.put("VolumeRecoveryPointTime", VOLUME_RECOVERY_POINT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VolumeRecoveryPointInfo, T> g) {
        return obj -> g.apply((VolumeRecoveryPointInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeRecoveryPointInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume target.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The size of the volume in bytes.
         * </p>
         * 
         * @param volumeSizeInBytes
         *        The size of the volume in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInBytes(Long volumeSizeInBytes);

        /**
         * <p>
         * The size of the data stored on the volume in bytes.
         * </p>
         * <note>
         * <p>
         * This value is not available for volumes created prior to May 13, 2015, until you store data on the volume.
         * </p>
         * </note>
         * 
         * @param volumeUsageInBytes
         *        The size of the data stored on the volume in bytes.</p> <note>
         *        <p>
         *        This value is not available for volumes created prior to May 13, 2015, until you store data on the
         *        volume.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeUsageInBytes(Long volumeUsageInBytes);

        /**
         * <p>
         * The time the recovery point was taken.
         * </p>
         * 
         * @param volumeRecoveryPointTime
         *        The time the recovery point was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeRecoveryPointTime(String volumeRecoveryPointTime);
    }

    static final class BuilderImpl implements Builder {
        private String volumeARN;

        private Long volumeSizeInBytes;

        private Long volumeUsageInBytes;

        private String volumeRecoveryPointTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeRecoveryPointInfo model) {
            volumeARN(model.volumeARN);
            volumeSizeInBytes(model.volumeSizeInBytes);
            volumeUsageInBytes(model.volumeUsageInBytes);
            volumeRecoveryPointTime(model.volumeRecoveryPointTime);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final Long getVolumeSizeInBytes() {
            return volumeSizeInBytes;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final Long getVolumeUsageInBytes() {
            return volumeUsageInBytes;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        @Override
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final String getVolumeRecoveryPointTime() {
            return volumeRecoveryPointTime;
        }

        public final void setVolumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
        }

        @Override
        public final Builder volumeRecoveryPointTime(String volumeRecoveryPointTime) {
            this.volumeRecoveryPointTime = volumeRecoveryPointTime;
            return this;
        }

        @Override
        public VolumeRecoveryPointInfo build() {
            return new VolumeRecoveryPointInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
