/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheReportFilter;
import software.amazon.awssdk.services.storagegateway.model.CacheReportFilterListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCacheReportRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, StartCacheReportRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(StartCacheReportRequest.getter(StartCacheReportRequest::fileShareARN)).setter(StartCacheReportRequest.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(StartCacheReportRequest.getter(StartCacheReportRequest::role)).setter(StartCacheReportRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(StartCacheReportRequest.getter(StartCacheReportRequest::locationARN)).setter(StartCacheReportRequest.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketRegion").getter(StartCacheReportRequest.getter(StartCacheReportRequest::bucketRegion)).setter(StartCacheReportRequest.setter(Builder::bucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VPCEndpointDNSName").getter(StartCacheReportRequest.getter(StartCacheReportRequest::vpcEndpointDNSName)).setter(StartCacheReportRequest.setter(Builder::vpcEndpointDNSName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCEndpointDNSName").build()}).build();
    private static final SdkField<List<CacheReportFilter>> INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionFilters").getter(StartCacheReportRequest.getter(StartCacheReportRequest::inclusionFilters)).setter(StartCacheReportRequest.setter(Builder::inclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheReportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CacheReportFilter>> EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionFilters").getter(StartCacheReportRequest.getter(StartCacheReportRequest::exclusionFilters)).setter(StartCacheReportRequest.setter(Builder::exclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheReportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartCacheReportRequest.getter(StartCacheReportRequest::clientToken)).setter(StartCacheReportRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartCacheReportRequest.getter(StartCacheReportRequest::tags)).setter(StartCacheReportRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, BUCKET_REGION_FIELD, VPC_ENDPOINT_DNS_NAME_FIELD, INCLUSION_FILTERS_FIELD, EXCLUSION_FILTERS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCacheReportRequest.memberNameToFieldInitializer();
    private final String fileShareARN;
    private final String role;
    private final String locationARN;
    private final String bucketRegion;
    private final String vpcEndpointDNSName;
    private final List<CacheReportFilter> inclusionFilters;
    private final List<CacheReportFilter> exclusionFilters;
    private final String clientToken;
    private final List<Tag> tags;

    private StartCacheReportRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.bucketRegion = builder.bucketRegion;
        this.vpcEndpointDNSName = builder.vpcEndpointDNSName;
        this.inclusionFilters = builder.inclusionFilters;
        this.exclusionFilters = builder.exclusionFilters;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final String role() {
        return this.role;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    public final String vpcEndpointDNSName() {
        return this.vpcEndpointDNSName;
    }

    public final boolean hasInclusionFilters() {
        return this.inclusionFilters != null && !(this.inclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<CacheReportFilter> inclusionFilters() {
        return this.inclusionFilters;
    }

    public final boolean hasExclusionFilters() {
        return this.exclusionFilters != null && !(this.exclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<CacheReportFilter> exclusionFilters() {
        return this.exclusionFilters;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointDNSName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFilters() ? this.inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFilters() ? this.exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCacheReportRequest)) {
            return false;
        }
        StartCacheReportRequest other = (StartCacheReportRequest)((Object)obj);
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.bucketRegion(), other.bucketRegion()) && Objects.equals(this.vpcEndpointDNSName(), other.vpcEndpointDNSName()) && this.hasInclusionFilters() == other.hasInclusionFilters() && Objects.equals(this.inclusionFilters(), other.inclusionFilters()) && this.hasExclusionFilters() == other.hasExclusionFilters() && Objects.equals(this.exclusionFilters(), other.exclusionFilters()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartCacheReportRequest").add("FileShareARN", (Object)this.fileShareARN()).add("Role", (Object)this.role()).add("LocationARN", (Object)this.locationARN()).add("BucketRegion", (Object)this.bucketRegion()).add("VPCEndpointDNSName", (Object)this.vpcEndpointDNSName()).add("InclusionFilters", this.hasInclusionFilters() ? this.inclusionFilters() : null).add("ExclusionFilters", this.hasExclusionFilters() ? this.exclusionFilters() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
            case "VPCEndpointDNSName": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointDNSName()));
            }
            case "InclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.inclusionFilters()));
            }
            case "ExclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.exclusionFilters()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("BucketRegion", BUCKET_REGION_FIELD);
        map.put("VPCEndpointDNSName", VPC_ENDPOINT_DNS_NAME_FIELD);
        map.put("InclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("ExclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCacheReportRequest, T> g) {
        return obj -> g.apply((StartCacheReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileShareARN;
        private String role;
        private String locationARN;
        private String bucketRegion;
        private String vpcEndpointDNSName;
        private List<CacheReportFilter> inclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CacheReportFilter> exclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCacheReportRequest model) {
            super(model);
            this.fileShareARN(model.fileShareARN);
            this.role(model.role);
            this.locationARN(model.locationARN);
            this.bucketRegion(model.bucketRegion);
            this.vpcEndpointDNSName(model.vpcEndpointDNSName);
            this.inclusionFilters(model.inclusionFilters);
            this.exclusionFilters(model.exclusionFilters);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final String getVpcEndpointDNSName() {
            return this.vpcEndpointDNSName;
        }

        public final void setVpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
        }

        @Override
        public final Builder vpcEndpointDNSName(String vpcEndpointDNSName) {
            this.vpcEndpointDNSName = vpcEndpointDNSName;
            return this;
        }

        public final List<CacheReportFilter.Builder> getInclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.inclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionFilters(Collection<CacheReportFilter.BuilderImpl> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copyFromBuilder(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(CacheReportFilter ... inclusionFilters) {
            this.inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(Consumer<CacheReportFilter.Builder> ... inclusionFilters) {
            this.inclusionFilters(Stream.of(inclusionFilters).map(c -> (CacheReportFilter)((CacheReportFilter.Builder)CacheReportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CacheReportFilter.Builder> getExclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.exclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionFilters(Collection<CacheReportFilter.BuilderImpl> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copyFromBuilder(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(CacheReportFilter ... exclusionFilters) {
            this.exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(Consumer<CacheReportFilter.Builder> ... exclusionFilters) {
            this.exclusionFilters(Stream.of(exclusionFilters).map(c -> (CacheReportFilter)((CacheReportFilter.Builder)CacheReportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCacheReportRequest build() {
            return new StartCacheReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCacheReportRequest> {
        public Builder fileShareARN(String var1);

        public Builder role(String var1);

        public Builder locationARN(String var1);

        public Builder bucketRegion(String var1);

        public Builder vpcEndpointDNSName(String var1);

        public Builder inclusionFilters(Collection<CacheReportFilter> var1);

        public Builder inclusionFilters(CacheReportFilter ... var1);

        public Builder inclusionFilters(Consumer<CacheReportFilter.Builder> ... var1);

        public Builder exclusionFilters(Collection<CacheReportFilter> var1);

        public Builder exclusionFilters(CacheReportFilter ... var1);

        public Builder exclusionFilters(Consumer<CacheReportFilter.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

