/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.FileShareClientListCopier;
import software.amazon.awssdk.services.storagegateway.model.NFSFileShareDefaults;
import software.amazon.awssdk.services.storagegateway.model.ObjectACL;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNfsFileShareRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, CreateNfsFileShareRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::clientToken)).setter(CreateNfsFileShareRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<NFSFileShareDefaults> NFS_FILE_SHARE_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::nfsFileShareDefaults)).setter(CreateNfsFileShareRequest.setter(Builder::nfsFileShareDefaults)).constructor(NFSFileShareDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NFSFileShareDefaults").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::gatewayARN)).setter(CreateNfsFileShareRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::kmsEncrypted)).setter(CreateNfsFileShareRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::kmsKey)).setter(CreateNfsFileShareRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::role)).setter(CreateNfsFileShareRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::locationARN)).setter(CreateNfsFileShareRequest.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<String> DEFAULT_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::defaultStorageClass)).setter(CreateNfsFileShareRequest.setter(Builder::defaultStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultStorageClass").build()}).build();
    private static final SdkField<String> OBJECT_ACL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::objectACLAsString)).setter(CreateNfsFileShareRequest.setter(Builder::objectACL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectACL").build()}).build();
    private static final SdkField<List<String>> CLIENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::clientList)).setter(CreateNfsFileShareRequest.setter(Builder::clientList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SQUASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::squash)).setter(CreateNfsFileShareRequest.setter(Builder::squash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Squash").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::readOnly)).setter(CreateNfsFileShareRequest.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<Boolean> GUESS_MIME_TYPE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::guessMIMETypeEnabled)).setter(CreateNfsFileShareRequest.setter(Builder::guessMIMETypeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuessMIMETypeEnabled").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::requesterPays)).setter(CreateNfsFileShareRequest.setter(Builder::requesterPays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPays").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNfsFileShareRequest.getter(CreateNfsFileShareRequest::tags)).setter(CreateNfsFileShareRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, NFS_FILE_SHARE_DEFAULTS_FIELD, GATEWAY_ARN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, ROLE_FIELD, LOCATION_ARN_FIELD, DEFAULT_STORAGE_CLASS_FIELD, OBJECT_ACL_FIELD, CLIENT_LIST_FIELD, SQUASH_FIELD, READ_ONLY_FIELD, GUESS_MIME_TYPE_ENABLED_FIELD, REQUESTER_PAYS_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final NFSFileShareDefaults nfsFileShareDefaults;
    private final String gatewayARN;
    private final Boolean kmsEncrypted;
    private final String kmsKey;
    private final String role;
    private final String locationARN;
    private final String defaultStorageClass;
    private final String objectACL;
    private final List<String> clientList;
    private final String squash;
    private final Boolean readOnly;
    private final Boolean guessMIMETypeEnabled;
    private final Boolean requesterPays;
    private final List<Tag> tags;

    private CreateNfsFileShareRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.nfsFileShareDefaults = builder.nfsFileShareDefaults;
        this.gatewayARN = builder.gatewayARN;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.role = builder.role;
        this.locationARN = builder.locationARN;
        this.defaultStorageClass = builder.defaultStorageClass;
        this.objectACL = builder.objectACL;
        this.clientList = builder.clientList;
        this.squash = builder.squash;
        this.readOnly = builder.readOnly;
        this.guessMIMETypeEnabled = builder.guessMIMETypeEnabled;
        this.requesterPays = builder.requesterPays;
        this.tags = builder.tags;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public NFSFileShareDefaults nfsFileShareDefaults() {
        return this.nfsFileShareDefaults;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    public String role() {
        return this.role;
    }

    public String locationARN() {
        return this.locationARN;
    }

    public String defaultStorageClass() {
        return this.defaultStorageClass;
    }

    public ObjectACL objectACL() {
        return ObjectACL.fromValue(this.objectACL);
    }

    public String objectACLAsString() {
        return this.objectACL;
    }

    public List<String> clientList() {
        return this.clientList;
    }

    public String squash() {
        return this.squash;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public Boolean guessMIMETypeEnabled() {
        return this.guessMIMETypeEnabled;
    }

    public Boolean requesterPays() {
        return this.requesterPays;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nfsFileShareDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultStorageClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectACLAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientList());
        hashCode = 31 * hashCode + Objects.hashCode(this.squash());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.guessMIMETypeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPays());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNfsFileShareRequest)) {
            return false;
        }
        CreateNfsFileShareRequest other = (CreateNfsFileShareRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.nfsFileShareDefaults(), other.nfsFileShareDefaults()) && Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.defaultStorageClass(), other.defaultStorageClass()) && Objects.equals(this.objectACLAsString(), other.objectACLAsString()) && Objects.equals(this.clientList(), other.clientList()) && Objects.equals(this.squash(), other.squash()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.guessMIMETypeEnabled(), other.guessMIMETypeEnabled()) && Objects.equals(this.requesterPays(), other.requesterPays()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateNfsFileShareRequest").add("ClientToken", (Object)this.clientToken()).add("NFSFileShareDefaults", (Object)this.nfsFileShareDefaults()).add("GatewayARN", (Object)this.gatewayARN()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).add("Role", (Object)this.role()).add("LocationARN", (Object)this.locationARN()).add("DefaultStorageClass", (Object)this.defaultStorageClass()).add("ObjectACL", (Object)this.objectACLAsString()).add("ClientList", this.clientList()).add("Squash", (Object)this.squash()).add("ReadOnly", (Object)this.readOnly()).add("GuessMIMETypeEnabled", (Object)this.guessMIMETypeEnabled()).add("RequesterPays", (Object)this.requesterPays()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "NFSFileShareDefaults": {
                return Optional.ofNullable(clazz.cast(this.nfsFileShareDefaults()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "DefaultStorageClass": {
                return Optional.ofNullable(clazz.cast(this.defaultStorageClass()));
            }
            case "ObjectACL": {
                return Optional.ofNullable(clazz.cast(this.objectACLAsString()));
            }
            case "ClientList": {
                return Optional.ofNullable(clazz.cast(this.clientList()));
            }
            case "Squash": {
                return Optional.ofNullable(clazz.cast(this.squash()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "GuessMIMETypeEnabled": {
                return Optional.ofNullable(clazz.cast(this.guessMIMETypeEnabled()));
            }
            case "RequesterPays": {
                return Optional.ofNullable(clazz.cast(this.requesterPays()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNfsFileShareRequest, T> g) {
        return obj -> g.apply((CreateNfsFileShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private NFSFileShareDefaults nfsFileShareDefaults;
        private String gatewayARN;
        private Boolean kmsEncrypted;
        private String kmsKey;
        private String role;
        private String locationARN;
        private String defaultStorageClass;
        private String objectACL;
        private List<String> clientList = DefaultSdkAutoConstructList.getInstance();
        private String squash;
        private Boolean readOnly;
        private Boolean guessMIMETypeEnabled;
        private Boolean requesterPays;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNfsFileShareRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.nfsFileShareDefaults(model.nfsFileShareDefaults);
            this.gatewayARN(model.gatewayARN);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
            this.role(model.role);
            this.locationARN(model.locationARN);
            this.defaultStorageClass(model.defaultStorageClass);
            this.objectACL(model.objectACL);
            this.clientList(model.clientList);
            this.squash(model.squash);
            this.readOnly(model.readOnly);
            this.guessMIMETypeEnabled(model.guessMIMETypeEnabled);
            this.requesterPays(model.requesterPays);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final NFSFileShareDefaults.Builder getNfsFileShareDefaults() {
            return this.nfsFileShareDefaults != null ? this.nfsFileShareDefaults.toBuilder() : null;
        }

        @Override
        public final Builder nfsFileShareDefaults(NFSFileShareDefaults nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults;
            return this;
        }

        public final void setNfsFileShareDefaults(NFSFileShareDefaults.BuilderImpl nfsFileShareDefaults) {
            this.nfsFileShareDefaults = nfsFileShareDefaults != null ? nfsFileShareDefaults.build() : null;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        public final String getDefaultStorageClass() {
            return this.defaultStorageClass;
        }

        @Override
        public final Builder defaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
            return this;
        }

        public final void setDefaultStorageClass(String defaultStorageClass) {
            this.defaultStorageClass = defaultStorageClass;
        }

        public final String getObjectACLAsString() {
            return this.objectACL;
        }

        @Override
        public final Builder objectACL(String objectACL) {
            this.objectACL = objectACL;
            return this;
        }

        @Override
        public final Builder objectACL(ObjectACL objectACL) {
            this.objectACL(objectACL.toString());
            return this;
        }

        public final void setObjectACL(String objectACL) {
            this.objectACL = objectACL;
        }

        public final Collection<String> getClientList() {
            return this.clientList;
        }

        @Override
        public final Builder clientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientList(String ... clientList) {
            this.clientList(Arrays.asList(clientList));
            return this;
        }

        public final void setClientList(Collection<String> clientList) {
            this.clientList = FileShareClientListCopier.copy(clientList);
        }

        public final String getSquash() {
            return this.squash;
        }

        @Override
        public final Builder squash(String squash) {
            this.squash = squash;
            return this;
        }

        public final void setSquash(String squash) {
            this.squash = squash;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public final Boolean getGuessMIMETypeEnabled() {
            return this.guessMIMETypeEnabled;
        }

        @Override
        public final Builder guessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
            return this;
        }

        public final void setGuessMIMETypeEnabled(Boolean guessMIMETypeEnabled) {
            this.guessMIMETypeEnabled = guessMIMETypeEnabled;
        }

        public final Boolean getRequesterPays() {
            return this.requesterPays;
        }

        @Override
        public final Builder requesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
            return this;
        }

        public final void setRequesterPays(Boolean requesterPays) {
            this.requesterPays = requesterPays;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNfsFileShareRequest build() {
            return new CreateNfsFileShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNfsFileShareRequest> {
        public Builder clientToken(String var1);

        public Builder nfsFileShareDefaults(NFSFileShareDefaults var1);

        default public Builder nfsFileShareDefaults(Consumer<NFSFileShareDefaults.Builder> nfsFileShareDefaults) {
            return this.nfsFileShareDefaults((NFSFileShareDefaults)((NFSFileShareDefaults.Builder)NFSFileShareDefaults.builder().applyMutation(nfsFileShareDefaults)).build());
        }

        public Builder gatewayARN(String var1);

        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder role(String var1);

        public Builder locationARN(String var1);

        public Builder defaultStorageClass(String var1);

        public Builder objectACL(String var1);

        public Builder objectACL(ObjectACL var1);

        public Builder clientList(Collection<String> var1);

        public Builder clientList(String ... var1);

        public Builder squash(String var1);

        public Builder readOnly(Boolean var1);

        public Builder guessMIMETypeEnabled(Boolean var1);

        public Builder requesterPays(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

