/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTapesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, CreateTapesResponse> {
    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTapesResponse.getter(CreateTapesResponse::tapeARNs)).setter(CreateTapesResponse.setter(Builder::tapeARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_AR_NS_FIELD));
    private final List<String> tapeARNs;

    private CreateTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapeARNs = builder.tapeARNs;
    }

    public List<String> tapeARNs() {
        return this.tapeARNs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapesResponse)) {
            return false;
        }
        CreateTapesResponse other = (CreateTapesResponse)((Object)obj);
        return Objects.equals(this.tapeARNs(), other.tapeARNs());
    }

    public String toString() {
        return ToString.builder((String)"CreateTapesResponse").add("TapeARNs", this.tapeARNs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARNs": {
                return Optional.ofNullable(clazz.cast(this.tapeARNs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapesResponse, T> g) {
        return obj -> g.apply((CreateTapesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapesResponse model) {
            super(model);
            this.tapeARNs(model.tapeARNs);
        }

        public final Collection<String> getTapeARNs() {
            return this.tapeARNs;
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String ... tapeARNs) {
            this.tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        @Override
        public CreateTapesResponse build() {
            return new CreateTapesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTapesResponse> {
        public Builder tapeARNs(Collection<String> var1);

        public Builder tapeARNs(String ... var1);
    }
}

