/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.GatewayNetworkInterfacesCopier;
import software.amazon.awssdk.services.storagegateway.model.NetworkInterface;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGatewayInformationResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeGatewayInformationResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayARN)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayId)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayName)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayTimezone)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()}).build();
    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayState)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayState").build()}).build();
    private static final SdkField<List<NetworkInterface>> GATEWAY_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayNetworkInterfaces)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::gatewayType)).setter(DescribeGatewayInformationResponse.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> NEXT_UPDATE_AVAILABILITY_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::nextUpdateAvailabilityDate)).setter(DescribeGatewayInformationResponse.setter(Builder::nextUpdateAvailabilityDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextUpdateAvailabilityDate").build()}).build();
    private static final SdkField<String> LAST_SOFTWARE_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::lastSoftwareUpdate)).setter(DescribeGatewayInformationResponse.setter(Builder::lastSoftwareUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSoftwareUpdate").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeGatewayInformationResponse.getter(DescribeGatewayInformationResponse::tags)).setter(DescribeGatewayInformationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_ID_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_STATE_FIELD, GATEWAY_NETWORK_INTERFACES_FIELD, GATEWAY_TYPE_FIELD, NEXT_UPDATE_AVAILABILITY_DATE_FIELD, LAST_SOFTWARE_UPDATE_FIELD, TAGS_FIELD));
    private final String gatewayARN;
    private final String gatewayId;
    private final String gatewayName;
    private final String gatewayTimezone;
    private final String gatewayState;
    private final List<NetworkInterface> gatewayNetworkInterfaces;
    private final String gatewayType;
    private final String nextUpdateAvailabilityDate;
    private final String lastSoftwareUpdate;
    private final List<Tag> tags;

    private DescribeGatewayInformationResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayState = builder.gatewayState;
        this.gatewayNetworkInterfaces = builder.gatewayNetworkInterfaces;
        this.gatewayType = builder.gatewayType;
        this.nextUpdateAvailabilityDate = builder.nextUpdateAvailabilityDate;
        this.lastSoftwareUpdate = builder.lastSoftwareUpdate;
        this.tags = builder.tags;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public String gatewayId() {
        return this.gatewayId;
    }

    public String gatewayName() {
        return this.gatewayName;
    }

    public String gatewayTimezone() {
        return this.gatewayTimezone;
    }

    public String gatewayState() {
        return this.gatewayState;
    }

    public List<NetworkInterface> gatewayNetworkInterfaces() {
        return this.gatewayNetworkInterfaces;
    }

    public String gatewayType() {
        return this.gatewayType;
    }

    public String nextUpdateAvailabilityDate() {
        return this.nextUpdateAvailabilityDate;
    }

    public String lastSoftwareUpdate() {
        return this.lastSoftwareUpdate;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayState());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayNetworkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextUpdateAvailabilityDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSoftwareUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayInformationResponse)) {
            return false;
        }
        DescribeGatewayInformationResponse other = (DescribeGatewayInformationResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayTimezone(), other.gatewayTimezone()) && Objects.equals(this.gatewayState(), other.gatewayState()) && Objects.equals(this.gatewayNetworkInterfaces(), other.gatewayNetworkInterfaces()) && Objects.equals(this.gatewayType(), other.gatewayType()) && Objects.equals(this.nextUpdateAvailabilityDate(), other.nextUpdateAvailabilityDate()) && Objects.equals(this.lastSoftwareUpdate(), other.lastSoftwareUpdate()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGatewayInformationResponse").add("GatewayARN", (Object)this.gatewayARN()).add("GatewayId", (Object)this.gatewayId()).add("GatewayName", (Object)this.gatewayName()).add("GatewayTimezone", (Object)this.gatewayTimezone()).add("GatewayState", (Object)this.gatewayState()).add("GatewayNetworkInterfaces", this.gatewayNetworkInterfaces()).add("GatewayType", (Object)this.gatewayType()).add("NextUpdateAvailabilityDate", (Object)this.nextUpdateAvailabilityDate()).add("LastSoftwareUpdate", (Object)this.lastSoftwareUpdate()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "GatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "GatewayTimezone": {
                return Optional.ofNullable(clazz.cast(this.gatewayTimezone()));
            }
            case "GatewayState": {
                return Optional.ofNullable(clazz.cast(this.gatewayState()));
            }
            case "GatewayNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.gatewayNetworkInterfaces()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayType()));
            }
            case "NextUpdateAvailabilityDate": {
                return Optional.ofNullable(clazz.cast(this.nextUpdateAvailabilityDate()));
            }
            case "LastSoftwareUpdate": {
                return Optional.ofNullable(clazz.cast(this.lastSoftwareUpdate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayInformationResponse, T> g) {
        return obj -> g.apply((DescribeGatewayInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String gatewayId;
        private String gatewayName;
        private String gatewayTimezone;
        private String gatewayState;
        private List<NetworkInterface> gatewayNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String gatewayType;
        private String nextUpdateAvailabilityDate;
        private String lastSoftwareUpdate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayInformationResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.gatewayId(model.gatewayId);
            this.gatewayName(model.gatewayName);
            this.gatewayTimezone(model.gatewayTimezone);
            this.gatewayState(model.gatewayState);
            this.gatewayNetworkInterfaces(model.gatewayNetworkInterfaces);
            this.gatewayType(model.gatewayType);
            this.nextUpdateAvailabilityDate(model.nextUpdateAvailabilityDate);
            this.lastSoftwareUpdate(model.lastSoftwareUpdate);
            this.tags(model.tags);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return this.gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getGatewayState() {
            return this.gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        public final Collection<NetworkInterface.Builder> getGatewayNetworkInterfaces() {
            return this.gatewayNetworkInterfaces != null ? (Collection)this.gatewayNetworkInterfaces.stream().map(NetworkInterface::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gatewayNetworkInterfaces(Collection<NetworkInterface> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copy(gatewayNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(NetworkInterface ... gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces(Arrays.asList(gatewayNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder> ... gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces(Stream.of(gatewayNetworkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGatewayNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> gatewayNetworkInterfaces) {
            this.gatewayNetworkInterfaces = GatewayNetworkInterfacesCopier.copyFromBuilder(gatewayNetworkInterfaces);
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getNextUpdateAvailabilityDate() {
            return this.nextUpdateAvailabilityDate;
        }

        @Override
        public final Builder nextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
            return this;
        }

        public final void setNextUpdateAvailabilityDate(String nextUpdateAvailabilityDate) {
            this.nextUpdateAvailabilityDate = nextUpdateAvailabilityDate;
        }

        public final String getLastSoftwareUpdate() {
            return this.lastSoftwareUpdate;
        }

        @Override
        public final Builder lastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
            return this;
        }

        public final void setLastSoftwareUpdate(String lastSoftwareUpdate) {
            this.lastSoftwareUpdate = lastSoftwareUpdate;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public DescribeGatewayInformationResponse build() {
            return new DescribeGatewayInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGatewayInformationResponse> {
        public Builder gatewayARN(String var1);

        public Builder gatewayId(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayTimezone(String var1);

        public Builder gatewayState(String var1);

        public Builder gatewayNetworkInterfaces(Collection<NetworkInterface> var1);

        public Builder gatewayNetworkInterfaces(NetworkInterface ... var1);

        public Builder gatewayNetworkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder gatewayType(String var1);

        public Builder nextUpdateAvailabilityDate(String var1);

        public Builder lastSoftwareUpdate(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

