/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolume;
import software.amazon.awssdk.services.storagegateway.model.StorediSCSIVolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorediScsiVolumesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeStorediScsiVolumesResponse> {
    private static final SdkField<List<StorediSCSIVolume>> STOREDI_SCSI_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeStorediScsiVolumesResponse.getter(DescribeStorediScsiVolumesResponse::storediSCSIVolumes)).setter(DescribeStorediScsiVolumesResponse.setter(Builder::storediSCSIVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorediSCSIVolumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorediSCSIVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOREDI_SCSI_VOLUMES_FIELD));
    private final List<StorediSCSIVolume> storediSCSIVolumes;

    private DescribeStorediScsiVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.storediSCSIVolumes = builder.storediSCSIVolumes;
    }

    public List<StorediSCSIVolume> storediSCSIVolumes() {
        return this.storediSCSIVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storediSCSIVolumes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorediScsiVolumesResponse)) {
            return false;
        }
        DescribeStorediScsiVolumesResponse other = (DescribeStorediScsiVolumesResponse)((Object)obj);
        return Objects.equals(this.storediSCSIVolumes(), other.storediSCSIVolumes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStorediScsiVolumesResponse").add("StorediSCSIVolumes", this.storediSCSIVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorediSCSIVolumes": {
                return Optional.ofNullable(clazz.cast(this.storediSCSIVolumes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorediScsiVolumesResponse, T> g) {
        return obj -> g.apply((DescribeStorediScsiVolumesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<StorediSCSIVolume> storediSCSIVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorediScsiVolumesResponse model) {
            super(model);
            this.storediSCSIVolumes(model.storediSCSIVolumes);
        }

        public final Collection<StorediSCSIVolume.Builder> getStorediSCSIVolumes() {
            return this.storediSCSIVolumes != null ? (Collection)this.storediSCSIVolumes.stream().map(StorediSCSIVolume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storediSCSIVolumes(Collection<StorediSCSIVolume> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copy(storediSCSIVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(StorediSCSIVolume ... storediSCSIVolumes) {
            this.storediSCSIVolumes(Arrays.asList(storediSCSIVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder> ... storediSCSIVolumes) {
            this.storediSCSIVolumes(Stream.of(storediSCSIVolumes).map(c -> (StorediSCSIVolume)((StorediSCSIVolume.Builder)StorediSCSIVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorediSCSIVolumes(Collection<StorediSCSIVolume.BuilderImpl> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copyFromBuilder(storediSCSIVolumes);
        }

        @Override
        public DescribeStorediScsiVolumesResponse build() {
            return new DescribeStorediScsiVolumesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorediScsiVolumesResponse> {
        public Builder storediSCSIVolumes(Collection<StorediSCSIVolume> var1);

        public Builder storediSCSIVolumes(StorediSCSIVolume ... var1);

        public Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder> ... var1);
    }
}

