/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.FileShareType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileShareInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileShareInfo> {
    private static final SdkField<String> FILE_SHARE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileShareInfo.getter(FileShareInfo::fileShareTypeAsString)).setter(FileShareInfo.setter(Builder::fileShareType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareType").build()}).build();
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileShareInfo.getter(FileShareInfo::fileShareARN)).setter(FileShareInfo.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> FILE_SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileShareInfo.getter(FileShareInfo::fileShareId)).setter(FileShareInfo.setter(Builder::fileShareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareId").build()}).build();
    private static final SdkField<String> FILE_SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileShareInfo.getter(FileShareInfo::fileShareStatus)).setter(FileShareInfo.setter(Builder::fileShareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FileShareInfo.getter(FileShareInfo::gatewayARN)).setter(FileShareInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_TYPE_FIELD, FILE_SHARE_ARN_FIELD, FILE_SHARE_ID_FIELD, FILE_SHARE_STATUS_FIELD, GATEWAY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileShareType;
    private final String fileShareARN;
    private final String fileShareId;
    private final String fileShareStatus;
    private final String gatewayARN;

    private FileShareInfo(BuilderImpl builder) {
        this.fileShareType = builder.fileShareType;
        this.fileShareARN = builder.fileShareARN;
        this.fileShareId = builder.fileShareId;
        this.fileShareStatus = builder.fileShareStatus;
        this.gatewayARN = builder.gatewayARN;
    }

    public FileShareType fileShareType() {
        return FileShareType.fromValue(this.fileShareType);
    }

    public String fileShareTypeAsString() {
        return this.fileShareType;
    }

    public String fileShareARN() {
        return this.fileShareARN;
    }

    public String fileShareId() {
        return this.fileShareId;
    }

    public String fileShareStatus() {
        return this.fileShareStatus;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileShareInfo)) {
            return false;
        }
        FileShareInfo other = (FileShareInfo)obj;
        return Objects.equals(this.fileShareTypeAsString(), other.fileShareTypeAsString()) && Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.fileShareId(), other.fileShareId()) && Objects.equals(this.fileShareStatus(), other.fileShareStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN());
    }

    public String toString() {
        return ToString.builder((String)"FileShareInfo").add("FileShareType", (Object)this.fileShareTypeAsString()).add("FileShareARN", (Object)this.fileShareARN()).add("FileShareId", (Object)this.fileShareId()).add("FileShareStatus", (Object)this.fileShareStatus()).add("GatewayARN", (Object)this.gatewayARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareType": {
                return Optional.ofNullable(clazz.cast(this.fileShareTypeAsString()));
            }
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "FileShareId": {
                return Optional.ofNullable(clazz.cast(this.fileShareId()));
            }
            case "FileShareStatus": {
                return Optional.ofNullable(clazz.cast(this.fileShareStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileShareInfo, T> g) {
        return obj -> g.apply((FileShareInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileShareType;
        private String fileShareARN;
        private String fileShareId;
        private String fileShareStatus;
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(FileShareInfo model) {
            this.fileShareType(model.fileShareType);
            this.fileShareARN(model.fileShareARN);
            this.fileShareId(model.fileShareId);
            this.fileShareStatus(model.fileShareStatus);
            this.gatewayARN(model.gatewayARN);
        }

        public final String getFileShareTypeAsString() {
            return this.fileShareType;
        }

        @Override
        public final Builder fileShareType(String fileShareType) {
            this.fileShareType = fileShareType;
            return this;
        }

        @Override
        public final Builder fileShareType(FileShareType fileShareType) {
            this.fileShareType(fileShareType.toString());
            return this;
        }

        public final void setFileShareType(String fileShareType) {
            this.fileShareType = fileShareType;
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        public final String getFileShareId() {
            return this.fileShareId;
        }

        @Override
        public final Builder fileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
            return this;
        }

        public final void setFileShareId(String fileShareId) {
            this.fileShareId = fileShareId;
        }

        public final String getFileShareStatus() {
            return this.fileShareStatus;
        }

        @Override
        public final Builder fileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
            return this;
        }

        public final void setFileShareStatus(String fileShareStatus) {
            this.fileShareStatus = fileShareStatus;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public FileShareInfo build() {
            return new FileShareInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileShareInfo> {
        public Builder fileShareType(String var1);

        public Builder fileShareType(FileShareType var1);

        public Builder fileShareARN(String var1);

        public Builder fileShareId(String var1);

        public Builder fileShareStatus(String var1);

        public Builder gatewayARN(String var1);
    }
}

