/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.InitiatorsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVolumeInitiatorsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
    private static final SdkField<List<String>> INITIATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListVolumeInitiatorsResponse.getter(ListVolumeInitiatorsResponse::initiators)).setter(ListVolumeInitiatorsResponse.setter(Builder::initiators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIATORS_FIELD));
    private final List<String> initiators;

    private ListVolumeInitiatorsResponse(BuilderImpl builder) {
        super(builder);
        this.initiators = builder.initiators;
    }

    public List<String> initiators() {
        return this.initiators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initiators());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVolumeInitiatorsResponse)) {
            return false;
        }
        ListVolumeInitiatorsResponse other = (ListVolumeInitiatorsResponse)((Object)obj);
        return Objects.equals(this.initiators(), other.initiators());
    }

    public String toString() {
        return ToString.builder((String)"ListVolumeInitiatorsResponse").add("Initiators", this.initiators()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Initiators": {
                return Optional.ofNullable(clazz.cast(this.initiators()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVolumeInitiatorsResponse, T> g) {
        return obj -> g.apply((ListVolumeInitiatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<String> initiators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVolumeInitiatorsResponse model) {
            super(model);
            this.initiators(model.initiators);
        }

        public final Collection<String> getInitiators() {
            return this.initiators;
        }

        @Override
        public final Builder initiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiators(String ... initiators) {
            this.initiators(Arrays.asList(initiators));
            return this;
        }

        public final void setInitiators(Collection<String> initiators) {
            this.initiators = InitiatorsCopier.copy(initiators);
        }

        @Override
        public ListVolumeInitiatorsResponse build() {
            return new ListVolumeInitiatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVolumeInitiatorsResponse> {
        public Builder initiators(Collection<String> var1);

        public Builder initiators(String ... var1);
    }
}

