/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse;
import software.amazon.awssdk.services.storagegateway.model.VTLDevice;

public class DescribeVTLDevicesIterable
implements SdkIterable<DescribeVtlDevicesResponse> {
    private final StorageGatewayClient client;
    private final DescribeVtlDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVTLDevicesIterable(StorageGatewayClient client, DescribeVtlDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVtlDevicesResponseFetcher();
    }

    public Iterator<DescribeVtlDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VTLDevice> vtlDevices() {
        Function<DescribeVtlDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vtlDevices() != null) {
                return response.vtlDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVtlDevicesResponseFetcher
    implements SyncPageFetcher<DescribeVtlDevicesResponse> {
        private DescribeVtlDevicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVtlDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeVtlDevicesResponse nextPage(DescribeVtlDevicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVTLDevicesIterable.this.client.describeVTLDevices(DescribeVTLDevicesIterable.this.firstRequest);
            }
            return DescribeVTLDevicesIterable.this.client.describeVTLDevices((DescribeVtlDevicesRequest)((Object)DescribeVTLDevicesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

