/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateGatewayRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, ActivateGatewayRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::activationKey)).setter(ActivateGatewayRequest.setter(Builder::activationKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()}).build();
    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::gatewayName)).setter(ActivateGatewayRequest.setter(Builder::gatewayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayName").build()}).build();
    private static final SdkField<String> GATEWAY_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::gatewayTimezone)).setter(ActivateGatewayRequest.setter(Builder::gatewayTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayTimezone").build()}).build();
    private static final SdkField<String> GATEWAY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::gatewayRegion)).setter(ActivateGatewayRequest.setter(Builder::gatewayRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayRegion").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::gatewayType)).setter(ActivateGatewayRequest.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> TAPE_DRIVE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::tapeDriveType)).setter(ActivateGatewayRequest.setter(Builder::tapeDriveType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeDriveType").build()}).build();
    private static final SdkField<String> MEDIUM_CHANGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::mediumChangerType)).setter(ActivateGatewayRequest.setter(Builder::mediumChangerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediumChangerType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ActivateGatewayRequest.getter(ActivateGatewayRequest::tags)).setter(ActivateGatewayRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD, GATEWAY_NAME_FIELD, GATEWAY_TIMEZONE_FIELD, GATEWAY_REGION_FIELD, GATEWAY_TYPE_FIELD, TAPE_DRIVE_TYPE_FIELD, MEDIUM_CHANGER_TYPE_FIELD, TAGS_FIELD));
    private final String activationKey;
    private final String gatewayName;
    private final String gatewayTimezone;
    private final String gatewayRegion;
    private final String gatewayType;
    private final String tapeDriveType;
    private final String mediumChangerType;
    private final List<Tag> tags;

    private ActivateGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.gatewayName = builder.gatewayName;
        this.gatewayTimezone = builder.gatewayTimezone;
        this.gatewayRegion = builder.gatewayRegion;
        this.gatewayType = builder.gatewayType;
        this.tapeDriveType = builder.tapeDriveType;
        this.mediumChangerType = builder.mediumChangerType;
        this.tags = builder.tags;
    }

    public String activationKey() {
        return this.activationKey;
    }

    public String gatewayName() {
        return this.gatewayName;
    }

    public String gatewayTimezone() {
        return this.gatewayTimezone;
    }

    public String gatewayRegion() {
        return this.gatewayRegion;
    }

    public String gatewayType() {
        return this.gatewayType;
    }

    public String tapeDriveType() {
        return this.tapeDriveType;
    }

    public String mediumChangerType() {
        return this.mediumChangerType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeDriveType());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediumChangerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateGatewayRequest)) {
            return false;
        }
        ActivateGatewayRequest other = (ActivateGatewayRequest)((Object)obj);
        return Objects.equals(this.activationKey(), other.activationKey()) && Objects.equals(this.gatewayName(), other.gatewayName()) && Objects.equals(this.gatewayTimezone(), other.gatewayTimezone()) && Objects.equals(this.gatewayRegion(), other.gatewayRegion()) && Objects.equals(this.gatewayType(), other.gatewayType()) && Objects.equals(this.tapeDriveType(), other.tapeDriveType()) && Objects.equals(this.mediumChangerType(), other.mediumChangerType()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ActivateGatewayRequest").add("ActivationKey", (Object)this.activationKey()).add("GatewayName", (Object)this.gatewayName()).add("GatewayTimezone", (Object)this.gatewayTimezone()).add("GatewayRegion", (Object)this.gatewayRegion()).add("GatewayType", (Object)this.gatewayType()).add("TapeDriveType", (Object)this.tapeDriveType()).add("MediumChangerType", (Object)this.mediumChangerType()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivationKey": {
                return Optional.ofNullable(clazz.cast(this.activationKey()));
            }
            case "GatewayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayName()));
            }
            case "GatewayTimezone": {
                return Optional.ofNullable(clazz.cast(this.gatewayTimezone()));
            }
            case "GatewayRegion": {
                return Optional.ofNullable(clazz.cast(this.gatewayRegion()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayType()));
            }
            case "TapeDriveType": {
                return Optional.ofNullable(clazz.cast(this.tapeDriveType()));
            }
            case "MediumChangerType": {
                return Optional.ofNullable(clazz.cast(this.mediumChangerType()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateGatewayRequest, T> g) {
        return obj -> g.apply((ActivateGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String activationKey;
        private String gatewayName;
        private String gatewayTimezone;
        private String gatewayRegion;
        private String gatewayType;
        private String tapeDriveType;
        private String mediumChangerType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateGatewayRequest model) {
            super(model);
            this.activationKey(model.activationKey);
            this.gatewayName(model.gatewayName);
            this.gatewayTimezone(model.gatewayTimezone);
            this.gatewayRegion(model.gatewayRegion);
            this.gatewayType(model.gatewayType);
            this.tapeDriveType(model.tapeDriveType);
            this.mediumChangerType(model.mediumChangerType);
            this.tags(model.tags);
        }

        public final String getActivationKey() {
            return this.activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        public final String getGatewayName() {
            return this.gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        public final String getGatewayTimezone() {
            return this.gatewayTimezone;
        }

        @Override
        public final Builder gatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
            return this;
        }

        public final void setGatewayTimezone(String gatewayTimezone) {
            this.gatewayTimezone = gatewayTimezone;
        }

        public final String getGatewayRegion() {
            return this.gatewayRegion;
        }

        @Override
        public final Builder gatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
            return this;
        }

        public final void setGatewayRegion(String gatewayRegion) {
            this.gatewayRegion = gatewayRegion;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        public final String getTapeDriveType() {
            return this.tapeDriveType;
        }

        @Override
        public final Builder tapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
            return this;
        }

        public final void setTapeDriveType(String tapeDriveType) {
            this.tapeDriveType = tapeDriveType;
        }

        public final String getMediumChangerType() {
            return this.mediumChangerType;
        }

        @Override
        public final Builder mediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
            return this;
        }

        public final void setMediumChangerType(String mediumChangerType) {
            this.mediumChangerType = mediumChangerType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateGatewayRequest build() {
            return new ActivateGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ActivateGatewayRequest> {
        public Builder activationKey(String var1);

        public Builder gatewayName(String var1);

        public Builder gatewayTimezone(String var1);

        public Builder gatewayRegion(String var1);

        public Builder gatewayType(String var1);

        public Builder tapeDriveType(String var1);

        public Builder mediumChangerType(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

