/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>AssumeRoleWithSAML</a> request, including temporary AWS credentials that can
 * be used to make AWS requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssumeRoleWithSAMLResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssumeRoleWithSAMLResponse.Builder, AssumeRoleWithSAMLResponse> {
    private final Credentials credentials;

    private final AssumedRoleUser assumedRoleUser;

    private final Integer packedPolicySize;

    private final String subject;

    private final String subjectType;

    private final String issuer;

    private final String audience;

    private final String nameQualifier;

    private AssumeRoleWithSAMLResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.subject = builder.subject;
        this.subjectType = builder.subjectType;
        this.issuer = builder.issuer;
        this.audience = builder.audience;
        this.nameQualifier = builder.nameQualifier;
    }

    /**
     * <p>
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
     * session) token.
     * </p>
     * <p>
     * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
     * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
     * that can vary. Also, future updates to AWS might require larger sizes.
     * </p>
     * 
     * @return The temporary security credentials, which include an access key ID, a secret access key, and a security
     *         (or session) token.</p>
     *         <p>
     *         <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that
     *         you make no assumptions about the maximum size. As of this writing, the typical size is less than 4096
     *         bytes, but that can vary. Also, future updates to AWS might require larger sizes.
     */
    public Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The identifiers for the temporary security credentials that the operation returns.
     * </p>
     * 
     * @return The identifiers for the temporary security credentials that the operation returns.
     */
    public AssumedRoleUser assumedRoleUser() {
        return assumedRoleUser;
    }

    /**
     * <p>
     * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with a
     * packed size greater than 100 percent, which means the policy exceeded the allowed space.
     * </p>
     * 
     * @return A percentage value that indicates the size of the policy in packed form. The service rejects any policy
     *         with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
     */
    public Integer packedPolicySize() {
        return packedPolicySize;
    }

    /**
     * <p>
     * The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.
     * </p>
     * 
     * @return The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element of
     * the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>.
     * </p>
     * <p>
     * If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is removed.
     * For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as
     * <code>transient</code>. If the format includes any other prefix, the format is returned with no modifications.
     * </p>
     * 
     * @return The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code>
     *         element of the SAML assertion. Typical examples of the format are <code>transient</code> or
     *         <code>persistent</code>. </p>
     *         <p>
     *         If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is
     *         removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as
     *         <code>transient</code>. If the format includes any other prefix, the format is returned with no
     *         modifications.
     */
    public String subjectType() {
        return subjectType;
    }

    /**
     * <p>
     * The value of the <code>Issuer</code> element of the SAML assertion.
     * </p>
     * 
     * @return The value of the <code>Issuer</code> element of the SAML assertion.
     */
    public String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the SAML
     * assertion.
     * </p>
     * 
     * @return The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of
     *         the SAML assertion.
     */
    public String audience() {
        return audience;
    }

    /**
     * <p>
     * A hash value based on the concatenation of the <code>Issuer</code> response value, the AWS account ID, and the
     * friendly name (the last part of the ARN) of the SAML provider in IAM. The combination of
     * <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.
     * </p>
     * <p>
     * The following pseudocode shows how the hash value is calculated:
     * </p>
     * <p>
     * <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code>
     * </p>
     * 
     * @return A hash value based on the concatenation of the <code>Issuer</code> response value, the AWS account ID,
     *         and the friendly name (the last part of the ARN) of the SAML provider in IAM. The combination of
     *         <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.
     *         </p>
     *         <p>
     *         The following pseudocode shows how the hash value is calculated:
     *         </p>
     *         <p>
     *         <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code>
     */
    public String nameQualifier() {
        return nameQualifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((credentials() == null) ? 0 : credentials().hashCode());
        hashCode = 31 * hashCode + ((assumedRoleUser() == null) ? 0 : assumedRoleUser().hashCode());
        hashCode = 31 * hashCode + ((packedPolicySize() == null) ? 0 : packedPolicySize().hashCode());
        hashCode = 31 * hashCode + ((subject() == null) ? 0 : subject().hashCode());
        hashCode = 31 * hashCode + ((subjectType() == null) ? 0 : subjectType().hashCode());
        hashCode = 31 * hashCode + ((issuer() == null) ? 0 : issuer().hashCode());
        hashCode = 31 * hashCode + ((audience() == null) ? 0 : audience().hashCode());
        hashCode = 31 * hashCode + ((nameQualifier() == null) ? 0 : nameQualifier().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSAMLResponse)) {
            return false;
        }
        AssumeRoleWithSAMLResponse other = (AssumeRoleWithSAMLResponse) obj;
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.assumedRoleUser() == null ^ this.assumedRoleUser() == null) {
            return false;
        }
        if (other.assumedRoleUser() != null && !other.assumedRoleUser().equals(this.assumedRoleUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        if (other.packedPolicySize() != null && !other.packedPolicySize().equals(this.packedPolicySize())) {
            return false;
        }
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.subjectType() == null ^ this.subjectType() == null) {
            return false;
        }
        if (other.subjectType() != null && !other.subjectType().equals(this.subjectType())) {
            return false;
        }
        if (other.issuer() == null ^ this.issuer() == null) {
            return false;
        }
        if (other.issuer() != null && !other.issuer().equals(this.issuer())) {
            return false;
        }
        if (other.audience() == null ^ this.audience() == null) {
            return false;
        }
        if (other.audience() != null && !other.audience().equals(this.audience())) {
            return false;
        }
        if (other.nameQualifier() == null ^ this.nameQualifier() == null) {
            return false;
        }
        if (other.nameQualifier() != null && !other.nameQualifier().equals(this.nameQualifier())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (credentials() != null) {
            sb.append("Credentials: ").append(credentials()).append(",");
        }
        if (assumedRoleUser() != null) {
            sb.append("AssumedRoleUser: ").append(assumedRoleUser()).append(",");
        }
        if (packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(packedPolicySize()).append(",");
        }
        if (subject() != null) {
            sb.append("Subject: ").append(subject()).append(",");
        }
        if (subjectType() != null) {
            sb.append("SubjectType: ").append(subjectType()).append(",");
        }
        if (issuer() != null) {
            sb.append("Issuer: ").append(issuer()).append(",");
        }
        if (audience() != null) {
            sb.append("Audience: ").append(audience()).append(",");
        }
        if (nameQualifier() != null) {
            sb.append("NameQualifier: ").append(nameQualifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AssumeRoleWithSAMLResponse> {
        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
         * session) token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials, which include an access key ID, a secret access key, and a
         *        security (or session) token.</p>
         *        <p>
         *        <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend
         *        that you make no assumptions about the maximum size. As of this writing, the typical size is less than
         *        4096 bytes, but that can vary. Also, future updates to AWS might require larger sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The identifiers for the temporary security credentials that the operation returns.
         * </p>
         * 
         * @param assumedRoleUser
         *        The identifiers for the temporary security credentials that the operation returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRoleUser(AssumedRoleUser assumedRoleUser);

        /**
         * <p>
         * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with
         * a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * </p>
         * 
         * @param packedPolicySize
         *        A percentage value that indicates the size of the policy in packed form. The service rejects any
         *        policy with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packedPolicySize(Integer packedPolicySize);

        /**
         * <p>
         * The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML assertion.
         * </p>
         * 
         * @param subject
         *        The value of the <code>NameID</code> element in the <code>Subject</code> element of the SAML
         *        assertion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code> element
         * of the SAML assertion. Typical examples of the format are <code>transient</code> or <code>persistent</code>.
         * </p>
         * <p>
         * If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix is
         * removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned as
         * <code>transient</code>. If the format includes any other prefix, the format is returned with no
         * modifications.
         * </p>
         * 
         * @param subjectType
         *        The format of the name ID, as defined by the <code>Format</code> attribute in the <code>NameID</code>
         *        element of the SAML assertion. Typical examples of the format are <code>transient</code> or
         *        <code>persistent</code>. </p>
         *        <p>
         *        If the format includes the prefix <code>urn:oasis:names:tc:SAML:2.0:nameid-format</code>, that prefix
         *        is removed. For example, <code>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</code> is returned
         *        as <code>transient</code>. If the format includes any other prefix, the format is returned with no
         *        modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectType(String subjectType);

        /**
         * <p>
         * The value of the <code>Issuer</code> element of the SAML assertion.
         * </p>
         * 
         * @param issuer
         *        The value of the <code>Issuer</code> element of the SAML assertion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element of the
         * SAML assertion.
         * </p>
         * 
         * @param audience
         *        The value of the <code>Recipient</code> attribute of the <code>SubjectConfirmationData</code> element
         *        of the SAML assertion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audience(String audience);

        /**
         * <p>
         * A hash value based on the concatenation of the <code>Issuer</code> response value, the AWS account ID, and
         * the friendly name (the last part of the ARN) of the SAML provider in IAM. The combination of
         * <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.
         * </p>
         * <p>
         * The following pseudocode shows how the hash value is calculated:
         * </p>
         * <p>
         * <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code>
         * </p>
         * 
         * @param nameQualifier
         *        A hash value based on the concatenation of the <code>Issuer</code> response value, the AWS account ID,
         *        and the friendly name (the last part of the ARN) of the SAML provider in IAM. The combination of
         *        <code>NameQualifier</code> and <code>Subject</code> can be used to uniquely identify a federated user.
         *        </p>
         *        <p>
         *        The following pseudocode shows how the hash value is calculated:
         *        </p>
         *        <p>
         *        <code>BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQualifier(String nameQualifier);
    }

    private static final class BuilderImpl implements Builder {
        private Credentials credentials;

        private AssumedRoleUser assumedRoleUser;

        private Integer packedPolicySize;

        private String subject;

        private String subjectType;

        private String issuer;

        private String audience;

        private String nameQualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSAMLResponse model) {
            setCredentials(model.credentials);
            setAssumedRoleUser(model.assumedRoleUser);
            setPackedPolicySize(model.packedPolicySize);
            setSubject(model.subject);
            setSubjectType(model.subjectType);
            setIssuer(model.issuer);
            setAudience(model.audience);
            setNameQualifier(model.nameQualifier);
        }

        public final Credentials getCredentials() {
            return credentials;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        public final AssumedRoleUser getAssumedRoleUser() {
            return assumedRoleUser;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
        }

        public final Integer getPackedPolicySize() {
            return packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getSubjectType() {
            return subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAudience() {
            return audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        public final String getNameQualifier() {
            return nameQualifier;
        }

        @Override
        public final Builder nameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
            return this;
        }

        public final void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        @Override
        public AssumeRoleWithSAMLResponse build() {
            return new AssumeRoleWithSAMLResponse(this);
        }
    }
}
