/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSessionTokenRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetSessionTokenRequest.Builder, GetSessionTokenRequest> {
    private final Integer durationSeconds;

    private final String serialNumber;

    private final String tokenCode;

    private GetSessionTokenRequest(BuilderImpl builder) {
        this.durationSeconds = builder.durationSeconds;
        this.serialNumber = builder.serialNumber;
        this.tokenCode = builder.tokenCode;
    }

    /**
     * <p>
     * The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user sessions
     * range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as the default.
     * Sessions for AWS account owners are restricted to a maximum of 3600 seconds (one hour). If the duration is longer
     * than one hour, the session for AWS account owners defaults to one hour.
     * </p>
     * 
     * @return The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user
     *         sessions range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours)
     *         as the default. Sessions for AWS account owners are restricted to a maximum of 3600 seconds (one hour).
     *         If the duration is longer than one hour, the session for AWS account owners defaults to one hour.
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The identification number of the MFA device that is associated with the IAM user who is making the
     * <code>GetSessionToken</code> call. Specify this value if the IAM user has a policy that requires MFA
     * authentication. The value is either the serial number for a hardware device (such as <code>GAHT12345678</code>)
     * or an Amazon Resource Name (ARN) for a virtual device (such as <code>arn:aws:iam::123456789012:mfa/user</code>).
     * You can find the device for an IAM user by going to the AWS Management Console and viewing the user's security
     * credentials.
     * </p>
     * <p>
     * The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
     * =,.@:/-
     * </p>
     * 
     * @return The identification number of the MFA device that is associated with the IAM user who is making the
     *         <code>GetSessionToken</code> call. Specify this value if the IAM user has a policy that requires MFA
     *         authentication. The value is either the serial number for a hardware device (such as
     *         <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
     *         <code>arn:aws:iam::123456789012:mfa/user</code>). You can find the device for an IAM user by going to the
     *         AWS Management Console and viewing the user's security credentials. </p>
     *         <p>
     *         The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@:/-
     */
    public String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit an MFA
     * code, specify this value. If MFA authentication is required, and the user does not provide a code when requesting
     * a set of temporary security credentials, the user will receive an "access denied" response when requesting
     * resources that require MFA authentication.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
     * </p>
     * 
     * @return The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit
     *         an MFA code, specify this value. If MFA authentication is required, and the user does not provide a code
     *         when requesting a set of temporary security credentials, the user will receive an "access denied"
     *         response when requesting resources that require MFA authentication.</p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
     */
    public String tokenCode() {
        return tokenCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((durationSeconds() == null) ? 0 : durationSeconds().hashCode());
        hashCode = 31 * hashCode + ((serialNumber() == null) ? 0 : serialNumber().hashCode());
        hashCode = 31 * hashCode + ((tokenCode() == null) ? 0 : tokenCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionTokenRequest)) {
            return false;
        }
        GetSessionTokenRequest other = (GetSessionTokenRequest) obj;
        if (other.durationSeconds() == null ^ this.durationSeconds() == null) {
            return false;
        }
        if (other.durationSeconds() != null && !other.durationSeconds().equals(this.durationSeconds())) {
            return false;
        }
        if (other.serialNumber() == null ^ this.serialNumber() == null) {
            return false;
        }
        if (other.serialNumber() != null && !other.serialNumber().equals(this.serialNumber())) {
            return false;
        }
        if (other.tokenCode() == null ^ this.tokenCode() == null) {
            return false;
        }
        if (other.tokenCode() != null && !other.tokenCode().equals(this.tokenCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(durationSeconds()).append(",");
        }
        if (serialNumber() != null) {
            sb.append("SerialNumber: ").append(serialNumber()).append(",");
        }
        if (tokenCode() != null) {
            sb.append("TokenCode: ").append(tokenCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSessionTokenRequest> {
        /**
         * <p>
         * The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user
         * sessions range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12 hours) as
         * the default. Sessions for AWS account owners are restricted to a maximum of 3600 seconds (one hour). If the
         * duration is longer than one hour, the session for AWS account owners defaults to one hour.
         * </p>
         * 
         * @param durationSeconds
         *        The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user
         *        sessions range from 900 seconds (15 minutes) to 129600 seconds (36 hours), with 43200 seconds (12
         *        hours) as the default. Sessions for AWS account owners are restricted to a maximum of 3600 seconds
         *        (one hour). If the duration is longer than one hour, the session for AWS account owners defaults to
         *        one hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * The identification number of the MFA device that is associated with the IAM user who is making the
         * <code>GetSessionToken</code> call. Specify this value if the IAM user has a policy that requires MFA
         * authentication. The value is either the serial number for a hardware device (such as
         * <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
         * <code>arn:aws:iam::123456789012:mfa/user</code>). You can find the device for an IAM user by going to the AWS
         * Management Console and viewing the user's security credentials.
         * </p>
         * <p>
         * The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@:/-
         * </p>
         * 
         * @param serialNumber
         *        The identification number of the MFA device that is associated with the IAM user who is making the
         *        <code>GetSessionToken</code> call. Specify this value if the IAM user has a policy that requires MFA
         *        authentication. The value is either the serial number for a hardware device (such as
         *        <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
         *        <code>arn:aws:iam::123456789012:mfa/user</code>). You can find the device for an IAM user by going to
         *        the AWS Management Console and viewing the user's security credentials. </p>
         *        <p>
         *        The regex used to validated this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@:/-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit an
         * MFA code, specify this value. If MFA authentication is required, and the user does not provide a code when
         * requesting a set of temporary security credentials, the user will receive an "access denied" response when
         * requesting resources that require MFA authentication.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
         * </p>
         * 
         * @param tokenCode
         *        The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to
         *        submit an MFA code, specify this value. If MFA authentication is required, and the user does not
         *        provide a code when requesting a set of temporary security credentials, the user will receive an
         *        "access denied" response when requesting resources that require MFA authentication.</p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenCode(String tokenCode);
    }

    private static final class BuilderImpl implements Builder {
        private Integer durationSeconds;

        private String serialNumber;

        private String tokenCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionTokenRequest model) {
            setDurationSeconds(model.durationSeconds);
            setSerialNumber(model.serialNumber);
            setTokenCode(model.tokenCode);
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getTokenCode() {
            return tokenCode;
        }

        @Override
        public final Builder tokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
            return this;
        }

        public final void setTokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
        }

        @Override
        public GetSessionTokenRequest build() {
            return new GetSessionTokenRequest(this);
        }
    }
}
