/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleWithSAMLResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AssumeRoleWithSAMLResponse> {
    private final Credentials credentials;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;
    private final String subject;
    private final String subjectType;
    private final String issuer;
    private final String audience;
    private final String nameQualifier;

    private AssumeRoleWithSAMLResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.subject = builder.subject;
        this.subjectType = builder.subjectType;
        this.issuer = builder.issuer;
        this.audience = builder.audience;
        this.nameQualifier = builder.nameQualifier;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public String subject() {
        return this.subject;
    }

    public String subjectType() {
        return this.subjectType;
    }

    public String issuer() {
        return this.issuer;
    }

    public String audience() {
        return this.audience;
    }

    public String nameQualifier() {
        return this.nameQualifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.credentials() == null ? 0 : this.credentials().hashCode());
        hashCode = 31 * hashCode + (this.assumedRoleUser() == null ? 0 : this.assumedRoleUser().hashCode());
        hashCode = 31 * hashCode + (this.packedPolicySize() == null ? 0 : this.packedPolicySize().hashCode());
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.subjectType() == null ? 0 : this.subjectType().hashCode());
        hashCode = 31 * hashCode + (this.issuer() == null ? 0 : this.issuer().hashCode());
        hashCode = 31 * hashCode + (this.audience() == null ? 0 : this.audience().hashCode());
        hashCode = 31 * hashCode + (this.nameQualifier() == null ? 0 : this.nameQualifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSAMLResponse)) {
            return false;
        }
        AssumeRoleWithSAMLResponse other = (AssumeRoleWithSAMLResponse)((Object)obj);
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.assumedRoleUser() == null ^ this.assumedRoleUser() == null) {
            return false;
        }
        if (other.assumedRoleUser() != null && !other.assumedRoleUser().equals(this.assumedRoleUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        if (other.packedPolicySize() != null && !other.packedPolicySize().equals(this.packedPolicySize())) {
            return false;
        }
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.subjectType() == null ^ this.subjectType() == null) {
            return false;
        }
        if (other.subjectType() != null && !other.subjectType().equals(this.subjectType())) {
            return false;
        }
        if (other.issuer() == null ^ this.issuer() == null) {
            return false;
        }
        if (other.issuer() != null && !other.issuer().equals(this.issuer())) {
            return false;
        }
        if (other.audience() == null ^ this.audience() == null) {
            return false;
        }
        if (other.audience() != null && !other.audience().equals(this.audience())) {
            return false;
        }
        if (other.nameQualifier() == null ^ this.nameQualifier() == null) {
            return false;
        }
        return other.nameQualifier() == null || other.nameQualifier().equals(this.nameQualifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (this.assumedRoleUser() != null) {
            sb.append("AssumedRoleUser: ").append(this.assumedRoleUser()).append(",");
        }
        if (this.packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(this.packedPolicySize()).append(",");
        }
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.subjectType() != null) {
            sb.append("SubjectType: ").append(this.subjectType()).append(",");
        }
        if (this.issuer() != null) {
            sb.append("Issuer: ").append(this.issuer()).append(",");
        }
        if (this.audience() != null) {
            sb.append("Audience: ").append(this.audience()).append(",");
        }
        if (this.nameQualifier() != null) {
            sb.append("NameQualifier: ").append(this.nameQualifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Credentials credentials;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;
        private String subject;
        private String subjectType;
        private String issuer;
        private String audience;
        private String nameQualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSAMLResponse model) {
            this.setCredentials(model.credentials);
            this.setAssumedRoleUser(model.assumedRoleUser);
            this.setPackedPolicySize(model.packedPolicySize);
            this.setSubject(model.subject);
            this.setSubjectType(model.subjectType);
            this.setIssuer(model.issuer);
            this.setAudience(model.audience);
            this.setNameQualifier(model.nameQualifier);
        }

        public final Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials credentials) {
            this.credentials = credentials;
        }

        public final AssumedRoleUser getAssumedRoleUser() {
            return this.assumedRoleUser;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getSubjectType() {
            return this.subjectType;
        }

        @Override
        public final Builder subjectType(String subjectType) {
            this.subjectType = subjectType;
            return this;
        }

        public final void setSubjectType(String subjectType) {
            this.subjectType = subjectType;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAudience() {
            return this.audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        public final String getNameQualifier() {
            return this.nameQualifier;
        }

        @Override
        public final Builder nameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
            return this;
        }

        public final void setNameQualifier(String nameQualifier) {
            this.nameQualifier = nameQualifier;
        }

        public AssumeRoleWithSAMLResponse build() {
            return new AssumeRoleWithSAMLResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssumeRoleWithSAMLResponse> {
        public Builder credentials(Credentials var1);

        public Builder assumedRoleUser(AssumedRoleUser var1);

        public Builder packedPolicySize(Integer var1);

        public Builder subject(String var1);

        public Builder subjectType(String var1);

        public Builder issuer(String var1);

        public Builder audience(String var1);

        public Builder nameQualifier(String var1);
    }
}

