/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>AssumeRole</a> request, including temporary AWS credentials that can be used
 * to make AWS requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeRoleResponse extends StsResponse implements
        ToCopyableBuilder<AssumeRoleResponse.Builder, AssumeRoleResponse> {
    private final Credentials credentials;

    private final AssumedRoleUser assumedRoleUser;

    private final Integer packedPolicySize;

    private AssumeRoleResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
    }

    /**
     * <p>
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
     * session) token.
     * </p>
     * <p>
     * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
     * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
     * that can vary. Also, future updates to AWS might require larger sizes.
     * </p>
     * 
     * @return The temporary security credentials, which include an access key ID, a secret access key, and a security
     *         (or session) token.</p>
     *         <p>
     *         <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that
     *         you make no assumptions about the maximum size. As of this writing, the typical size is less than 4096
     *         bytes, but that can vary. Also, future updates to AWS might require larger sizes.
     */
    public Credentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the
     * resulting temporary security credentials. For example, you can reference these credentials as a principal in a
     * resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
     * <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer
     *         to the resulting temporary security credentials. For example, you can reference these credentials as a
     *         principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
     *         <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
     */
    public AssumedRoleUser assumedRoleUser() {
        return assumedRoleUser;
    }

    /**
     * <p>
     * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with a
     * packed size greater than 100 percent, which means the policy exceeded the allowed space.
     * </p>
     * 
     * @return A percentage value that indicates the size of the policy in packed form. The service rejects any policy
     *         with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
     */
    public Integer packedPolicySize() {
        return packedPolicySize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(packedPolicySize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleResponse)) {
            return false;
        }
        AssumeRoleResponse other = (AssumeRoleResponse) obj;
        return Objects.equals(credentials(), other.credentials()) && Objects.equals(assumedRoleUser(), other.assumedRoleUser())
                && Objects.equals(packedPolicySize(), other.packedPolicySize());
    }

    @Override
    public String toString() {
        return ToString.builder("AssumeRoleResponse").add("Credentials", credentials()).add("AssumedRoleUser", assumedRoleUser())
                .add("PackedPolicySize", packedPolicySize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "AssumedRoleUser":
            return Optional.ofNullable(clazz.cast(assumedRoleUser()));
        case "PackedPolicySize":
            return Optional.ofNullable(clazz.cast(packedPolicySize()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends StsResponse.Builder, CopyableBuilder<Builder, AssumeRoleResponse> {
        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
         * session) token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * 
         * @param credentials
         *        The temporary security credentials, which include an access key ID, a secret access key, and a
         *        security (or session) token.</p>
         *        <p>
         *        <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend
         *        that you make no assumptions about the maximum size. As of this writing, the typical size is less than
         *        4096 bytes, but that can vary. Also, future updates to AWS might require larger sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(Credentials credentials);

        /**
         * <p>
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or
         * session) token.
         * </p>
         * <p>
         * <b>Note:</b> The size of the security token that STS APIs return is not fixed. We strongly recommend that you
         * make no assumptions about the maximum size. As of this writing, the typical size is less than 4096 bytes, but
         * that can vary. Also, future updates to AWS might require larger sizes.
         * </p>
         * This is a convenience that creates an instance of the {@link Credentials.Builder} avoiding the need to create
         * one manually via {@link Credentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link Credentials.Builder#build()} is called immediately and its result
         * is passed to {@link #credentials(Credentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link Credentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(Credentials)
         */
        default Builder credentials(Consumer<Credentials.Builder> credentials) {
            return credentials(Credentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to
         * the resulting temporary security credentials. For example, you can reference these credentials as a principal
         * in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
         * <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
         * </p>
         * 
         * @param assumedRoleUser
         *        The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to
         *        refer to the resulting temporary security credentials. For example, you can reference these
         *        credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and
         *        ID include the <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRoleUser(AssumedRoleUser assumedRoleUser);

        /**
         * <p>
         * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to
         * the resulting temporary security credentials. For example, you can reference these credentials as a principal
         * in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the
         * <code>RoleSessionName</code> that you specified when you called <code>AssumeRole</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AssumedRoleUser.Builder} avoiding the need to
         * create one manually via {@link AssumedRoleUser#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssumedRoleUser.Builder#build()} is called immediately and its
         * result is passed to {@link #assumedRoleUser(AssumedRoleUser)}.
         * 
         * @param assumedRoleUser
         *        a consumer that will call methods on {@link AssumedRoleUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assumedRoleUser(AssumedRoleUser)
         */
        default Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return assumedRoleUser(AssumedRoleUser.builder().applyMutation(assumedRoleUser).build());
        }

        /**
         * <p>
         * A percentage value that indicates the size of the policy in packed form. The service rejects any policy with
         * a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * </p>
         * 
         * @param packedPolicySize
         *        A percentage value that indicates the size of the policy in packed form. The service rejects any
         *        policy with a packed size greater than 100 percent, which means the policy exceeded the allowed space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packedPolicySize(Integer packedPolicySize);
    }

    static final class BuilderImpl extends StsResponse.BuilderImpl implements Builder {
        private Credentials credentials;

        private AssumedRoleUser assumedRoleUser;

        private Integer packedPolicySize;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleResponse model) {
            super(model);
            credentials(model.credentials);
            assumedRoleUser(model.assumedRoleUser);
            packedPolicySize(model.packedPolicySize);
        }

        public final Credentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return assumedRoleUser != null ? assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public AssumeRoleResponse build() {
            return new AssumeRoleResponse(this);
        }
    }
}
