/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeRoleWithWebIdentityRequest extends StsRequest implements
        ToCopyableBuilder<AssumeRoleWithWebIdentityRequest.Builder, AssumeRoleWithWebIdentityRequest> {
    private final String roleArn;

    private final String roleSessionName;

    private final String webIdentityToken;

    private final String providerId;

    private final String policy;

    private final Integer durationSeconds;

    private AssumeRoleWithWebIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.webIdentityToken = builder.webIdentityToken;
        this.providerId = builder.providerId;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that the caller is assuming.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that the caller is assuming.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An identifier for the assumed role session. Typically, you pass the name or identifier that is associated with
     * the user who is using your application. That way, the temporary security credentials that your application will
     * use are associated with that user. This session name is included as part of the ARN and assumed role ID in the
     * <code>AssumedRoleUser</code> response element.
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     * </p>
     * 
     * @return An identifier for the assumed role session. Typically, you pass the name or identifier that is associated
     *         with the user who is using your application. That way, the temporary security credentials that your
     *         application will use are associated with that user. This session name is included as part of the ARN and
     *         assumed role ID in the <code>AssumedRoleUser</code> response element.</p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@-
     */
    public String roleSessionName() {
        return roleSessionName;
    }

    /**
     * <p>
     * The OAuth 2.0 access token or OpenID Connect ID token that is provided by the identity provider. Your application
     * must get this token by authenticating the user who is using your application with a web identity provider before
     * the application makes an <code>AssumeRoleWithWebIdentity</code> call.
     * </p>
     * 
     * @return The OAuth 2.0 access token or OpenID Connect ID token that is provided by the identity provider. Your
     *         application must get this token by authenticating the user who is using your application with a web
     *         identity provider before the application makes an <code>AssumeRoleWithWebIdentity</code> call.
     */
    public String webIdentityToken() {
        return webIdentityToken;
    }

    /**
     * <p>
     * The fully qualified host component of the domain name of the identity provider.
     * </p>
     * <p>
     * Specify this value only for OAuth 2.0 access tokens. Currently <code>www.amazon.com</code> and
     * <code>graph.facebook.com</code> are the only supported identity providers for OAuth 2.0 access tokens. Do not
     * include URL schemes and port numbers.
     * </p>
     * <p>
     * Do not specify this value for OpenID Connect ID tokens.
     * </p>
     * 
     * @return The fully qualified host component of the domain name of the identity provider.</p>
     *         <p>
     *         Specify this value only for OAuth 2.0 access tokens. Currently <code>www.amazon.com</code> and
     *         <code>graph.facebook.com</code> are the only supported identity providers for OAuth 2.0 access tokens. Do
     *         not include URL schemes and port numbers.
     *         </p>
     *         <p>
     *         Do not specify this value for OpenID Connect ID tokens.
     */
    public String providerId() {
        return providerId;
    }

    /**
     * <p>
     * An IAM policy in JSON format.
     * </p>
     * <p>
     * The policy parameter is optional. If you pass a policy, the temporary security credentials that are returned by
     * the operation have the permissions that are allowed by both the access policy of the role that is being assumed,
     * <i> <b>and</b> </i> the policy that you pass. This gives you a way to further restrict the permissions for the
     * resulting temporary security credentials. You cannot use the passed policy to grant permissions that are in
     * excess of those allowed by the access policy of the role that is being assumed. For more information, see <a
     * href=
     * "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">Permissions
     * for AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048 characters
     * in length. The characters can be any ASCII character from the space character to the end of the valid character
     * list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a packed
     * binary format with a separate limit. The PackedPolicySize response element indicates by percentage how close to
     * the upper size limit the policy is, with 100% equaling the maximum allowed size.
     * </p>
     * </note>
     * 
     * @return An IAM policy in JSON format.</p>
     *         <p>
     *         The policy parameter is optional. If you pass a policy, the temporary security credentials that are
     *         returned by the operation have the permissions that are allowed by both the access policy of the role
     *         that is being assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further
     *         restrict the permissions for the resulting temporary security credentials. You cannot use the passed
     *         policy to grant permissions that are in excess of those allowed by the access policy of the role that is
     *         being assumed. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
     *         >Permissions for AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
     *         </p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
     *         characters in length. The characters can be any ASCII character from the space character to the end of
     *         the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return (
     *         ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
     *         packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage
     *         how close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
     *         </p>
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600 seconds
     * (1 hour). By default, the value is set to 3600 seconds.
     * </p>
     * <note>
     * <p>
     * This is separate from the duration of a console session that you might request using the returned credentials.
     * The request to the federation endpoint for a console sign-in token takes a <code>SessionDuration</code> parameter
     * that specifies the maximum length of the console session, separately from the <code>DurationSeconds</code>
     * parameter on this API. For more information, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html">Creating
     * a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600
     *         seconds (1 hour). By default, the value is set to 3600 seconds.</p> <note>
     *         <p>
     *         This is separate from the duration of a console session that you might request using the returned
     *         credentials. The request to the federation endpoint for a console sign-in token takes a
     *         <code>SessionDuration</code> parameter that specifies the maximum length of the console session,
     *         separately from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html">
     *         Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(webIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(providerId());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithWebIdentityRequest)) {
            return false;
        }
        AssumeRoleWithWebIdentityRequest other = (AssumeRoleWithWebIdentityRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(roleSessionName(), other.roleSessionName())
                && Objects.equals(webIdentityToken(), other.webIdentityToken())
                && Objects.equals(providerId(), other.providerId()) && Objects.equals(policy(), other.policy())
                && Objects.equals(durationSeconds(), other.durationSeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("AssumeRoleWithWebIdentityRequest").add("RoleArn", roleArn())
                .add("RoleSessionName", roleSessionName()).add("WebIdentityToken", webIdentityToken())
                .add("ProviderId", providerId()).add("Policy", policy()).add("DurationSeconds", durationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "RoleSessionName":
            return Optional.ofNullable(clazz.cast(roleSessionName()));
        case "WebIdentityToken":
            return Optional.ofNullable(clazz.cast(webIdentityToken()));
        case "ProviderId":
            return Optional.ofNullable(clazz.cast(providerId()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends StsRequest.Builder, CopyableBuilder<Builder, AssumeRoleWithWebIdentityRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An identifier for the assumed role session. Typically, you pass the name or identifier that is associated
         * with the user who is using your application. That way, the temporary security credentials that your
         * application will use are associated with that user. This session name is included as part of the ARN and
         * assumed role ID in the <code>AssumedRoleUser</code> response element.
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@-
         * </p>
         * 
         * @param roleSessionName
         *        An identifier for the assumed role session. Typically, you pass the name or identifier that is
         *        associated with the user who is using your application. That way, the temporary security credentials
         *        that your application will use are associated with that user. This session name is included as part of
         *        the ARN and assumed role ID in the <code>AssumedRoleUser</code> response element.</p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSessionName(String roleSessionName);

        /**
         * <p>
         * The OAuth 2.0 access token or OpenID Connect ID token that is provided by the identity provider. Your
         * application must get this token by authenticating the user who is using your application with a web identity
         * provider before the application makes an <code>AssumeRoleWithWebIdentity</code> call.
         * </p>
         * 
         * @param webIdentityToken
         *        The OAuth 2.0 access token or OpenID Connect ID token that is provided by the identity provider. Your
         *        application must get this token by authenticating the user who is using your application with a web
         *        identity provider before the application makes an <code>AssumeRoleWithWebIdentity</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webIdentityToken(String webIdentityToken);

        /**
         * <p>
         * The fully qualified host component of the domain name of the identity provider.
         * </p>
         * <p>
         * Specify this value only for OAuth 2.0 access tokens. Currently <code>www.amazon.com</code> and
         * <code>graph.facebook.com</code> are the only supported identity providers for OAuth 2.0 access tokens. Do not
         * include URL schemes and port numbers.
         * </p>
         * <p>
         * Do not specify this value for OpenID Connect ID tokens.
         * </p>
         * 
         * @param providerId
         *        The fully qualified host component of the domain name of the identity provider.</p>
         *        <p>
         *        Specify this value only for OAuth 2.0 access tokens. Currently <code>www.amazon.com</code> and
         *        <code>graph.facebook.com</code> are the only supported identity providers for OAuth 2.0 access tokens.
         *        Do not include URL schemes and port numbers.
         *        </p>
         *        <p>
         *        Do not specify this value for OpenID Connect ID tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerId(String providerId);

        /**
         * <p>
         * An IAM policy in JSON format.
         * </p>
         * <p>
         * The policy parameter is optional. If you pass a policy, the temporary security credentials that are returned
         * by the operation have the permissions that are allowed by both the access policy of the role that is being
         * assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further restrict the
         * permissions for the resulting temporary security credentials. You cannot use the passed policy to grant
         * permissions that are in excess of those allowed by the access policy of the role that is being assumed. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         * >Permissions for AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         * characters in length. The characters can be any ASCII character from the space character to the end of the
         * valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
         * packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage how
         * close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
         * </p>
         * </note>
         * 
         * @param policy
         *        An IAM policy in JSON format.</p>
         *        <p>
         *        The policy parameter is optional. If you pass a policy, the temporary security credentials that are
         *        returned by the operation have the permissions that are allowed by both the access policy of the role
         *        that is being assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further
         *        restrict the permissions for the resulting temporary security credentials. You cannot use the passed
         *        policy to grant permissions that are in excess of those allowed by the access policy of the role that
         *        is being assumed. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         *        >Permissions for AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
         *        </p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         *        characters in length. The characters can be any ASCII character from the space character to the end of
         *        the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage
         *        return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it
         *        into a packed binary format with a separate limit. The PackedPolicySize response element indicates by
         *        percentage how close to the upper size limit the policy is, with 100% equaling the maximum allowed
         *        size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600
         * seconds (1 hour). By default, the value is set to 3600 seconds.
         * </p>
         * <note>
         * <p>
         * This is separate from the duration of a console session that you might request using the returned
         * credentials. The request to the federation endpoint for a console sign-in token takes a
         * <code>SessionDuration</code> parameter that specifies the maximum length of the console session, separately
         * from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         * >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param durationSeconds
         *        The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to
         *        3600 seconds (1 hour). By default, the value is set to 3600 seconds.</p> <note>
         *        <p>
         *        This is separate from the duration of a console session that you might request using the returned
         *        credentials. The request to the federation endpoint for a console sign-in token takes a
         *        <code>SessionDuration</code> parameter that specifies the maximum length of the console session,
         *        separately from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
         *        href
         *        ="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         *        >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String roleArn;

        private String roleSessionName;

        private String webIdentityToken;

        private String providerId;

        private String policy;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithWebIdentityRequest model) {
            super(model);
            roleArn(model.roleArn);
            roleSessionName(model.roleSessionName);
            webIdentityToken(model.webIdentityToken);
            providerId(model.providerId);
            policy(model.policy);
            durationSeconds(model.durationSeconds);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getRoleSessionName() {
            return roleSessionName;
        }

        @Override
        public final Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public final void setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
        }

        public final String getWebIdentityToken() {
            return webIdentityToken;
        }

        @Override
        public final Builder webIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
            return this;
        }

        public final void setWebIdentityToken(String webIdentityToken) {
            this.webIdentityToken = webIdentityToken;
        }

        public final String getProviderId() {
            return providerId;
        }

        @Override
        public final Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public final void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeRoleWithWebIdentityRequest build() {
            return new AssumeRoleWithWebIdentityRequest(this);
        }
    }
}
