/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecodeAuthorizationMessageRequest extends StsRequest implements
        ToCopyableBuilder<DecodeAuthorizationMessageRequest.Builder, DecodeAuthorizationMessageRequest> {
    private final String encodedMessage;

    private DecodeAuthorizationMessageRequest(BuilderImpl builder) {
        super(builder);
        this.encodedMessage = builder.encodedMessage;
    }

    /**
     * <p>
     * The encoded message that was returned with the response.
     * </p>
     * 
     * @return The encoded message that was returned with the response.
     */
    public String encodedMessage() {
        return encodedMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encodedMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecodeAuthorizationMessageRequest)) {
            return false;
        }
        DecodeAuthorizationMessageRequest other = (DecodeAuthorizationMessageRequest) obj;
        return Objects.equals(encodedMessage(), other.encodedMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("DecodeAuthorizationMessageRequest").add("EncodedMessage", encodedMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncodedMessage":
            return Optional.ofNullable(clazz.cast(encodedMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends StsRequest.Builder, CopyableBuilder<Builder, DecodeAuthorizationMessageRequest> {
        /**
         * <p>
         * The encoded message that was returned with the response.
         * </p>
         * 
         * @param encodedMessage
         *        The encoded message that was returned with the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedMessage(String encodedMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String encodedMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DecodeAuthorizationMessageRequest model) {
            super(model);
            encodedMessage(model.encodedMessage);
        }

        public final String getEncodedMessage() {
            return encodedMessage;
        }

        @Override
        public final Builder encodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
            return this;
        }

        public final void setEncodedMessage(String encodedMessage) {
            this.encodedMessage = encodedMessage;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecodeAuthorizationMessageRequest build() {
            return new DecodeAuthorizationMessageRequest(this);
        }
    }
}
