/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sts.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * AssumeRoleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssumeRoleRequestMarshaller implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {

    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {

        if (assumeRoleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<AssumeRoleRequest> request = new DefaultRequest<AssumeRoleRequest>(assumeRoleRequest, "StsClient");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (assumeRoleRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString(assumeRoleRequest.roleArn()));
        }

        if (assumeRoleRequest.roleSessionName() != null) {
            request.addParameter("RoleSessionName", StringConversion.fromString(assumeRoleRequest.roleSessionName()));
        }

        if (assumeRoleRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString(assumeRoleRequest.policy()));
        }

        if (assumeRoleRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger(assumeRoleRequest.durationSeconds()));
        }

        if (assumeRoleRequest.externalId() != null) {
            request.addParameter("ExternalId", StringConversion.fromString(assumeRoleRequest.externalId()));
        }

        if (assumeRoleRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringConversion.fromString(assumeRoleRequest.serialNumber()));
        }

        if (assumeRoleRequest.tokenCode() != null) {
            request.addParameter("TokenCode", StringConversion.fromString(assumeRoleRequest.tokenCode()));
        }

        return request;
    }

}
