/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;

public class GetSessionTokenRequestMarshaller
implements Marshaller<Request<GetSessionTokenRequest>, GetSessionTokenRequest> {
    public Request<GetSessionTokenRequest> marshall(GetSessionTokenRequest getSessionTokenRequest) {
        if (getSessionTokenRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getSessionTokenRequest, "StsClient");
        request.addParameter("Action", "GetSessionToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSessionTokenRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger((Integer)getSessionTokenRequest.durationSeconds()));
        }
        if (getSessionTokenRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringConversion.fromString((String)getSessionTokenRequest.serialNumber()));
        }
        if (getSessionTokenRequest.tokenCode() != null) {
            request.addParameter("TokenCode", StringConversion.fromString((String)getSessionTokenRequest.tokenCode()));
        }
        return request;
    }
}

