/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeRoleRequest extends StsRequest implements
        ToCopyableBuilder<AssumeRoleRequest.Builder, AssumeRoleRequest> {
    private final String roleArn;

    private final String roleSessionName;

    private final String policy;

    private final Integer durationSeconds;

    private final String externalId;

    private final String serialNumber;

    private final String tokenCode;

    private AssumeRoleRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
        this.externalId = builder.externalId;
        this.serialNumber = builder.serialNumber;
        this.tokenCode = builder.tokenCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role to assume.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role to assume.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * An identifier for the assumed role session.
     * </p>
     * <p>
     * Use the role session name to uniquely identify a session when the same role is assumed by different principals or
     * for different reasons. In cross-account scenarios, the role session name is visible to, and can be logged by the
     * account that owns the role. The role session name is also used in the ARN of the assumed role principal. This
     * means that subsequent cross-account API requests using the temporary security credentials will expose the role
     * session name to the external account in their CloudTrail logs.
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     * </p>
     * 
     * @return An identifier for the assumed role session.</p>
     *         <p>
     *         Use the role session name to uniquely identify a session when the same role is assumed by different
     *         principals or for different reasons. In cross-account scenarios, the role session name is visible to, and
     *         can be logged by the account that owns the role. The role session name is also used in the ARN of the
     *         assumed role principal. This means that subsequent cross-account API requests using the temporary
     *         security credentials will expose the role session name to the external account in their CloudTrail logs.
     *         </p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@-
     */
    public String roleSessionName() {
        return roleSessionName;
    }

    /**
     * <p>
     * An IAM policy in JSON format.
     * </p>
     * <p>
     * This parameter is optional. If you pass a policy, the temporary security credentials that are returned by the
     * operation have the permissions that are allowed by both (the intersection of) the access policy of the role that
     * is being assumed, <i>and</i> the policy that you pass. This gives you a way to further restrict the permissions
     * for the resulting temporary security credentials. You cannot use the passed policy to grant permissions that are
     * in excess of those allowed by the access policy of the role that is being assumed. For more information, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html">
     * Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048 characters
     * in length. The characters can be any ASCII character from the space character to the end of the valid character
     * list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a packed
     * binary format with a separate limit. The PackedPolicySize response element indicates by percentage how close to
     * the upper size limit the policy is, with 100% equaling the maximum allowed size.
     * </p>
     * </note>
     * 
     * @return An IAM policy in JSON format.</p>
     *         <p>
     *         This parameter is optional. If you pass a policy, the temporary security credentials that are returned by
     *         the operation have the permissions that are allowed by both (the intersection of) the access policy of
     *         the role that is being assumed, <i>and</i> the policy that you pass. This gives you a way to further
     *         restrict the permissions for the resulting temporary security credentials. You cannot use the passed
     *         policy to grant permissions that are in excess of those allowed by the access policy of the role that is
     *         being assumed. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
     *         >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
     *         characters in length. The characters can be any ASCII character from the space character to the end of
     *         the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return (
     *         ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
     *         packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage
     *         how close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
     *         </p>
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to the
     * maximum session duration setting for the role. This setting can have a value from 1 hour to 12 hours. If you
     * specify a value higher than this setting, the operation fails. For example, if you specify a session duration of
     * 12 hours, but your administrator set the maximum session duration to 6 hours, your operation fails. To learn how
     * to view the maximum value for your role, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session">View
     * the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * By default, the value is set to 3600 seconds.
     * </p>
     * <note>
     * <p>
     * The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you might
     * request using the returned credentials. The request to the federation endpoint for a console sign-in token takes
     * a <code>SessionDuration</code> parameter that specifies the maximum length of the console session. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html">Creating
     * a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to
     *         the maximum session duration setting for the role. This setting can have a value from 1 hour to 12 hours.
     *         If you specify a value higher than this setting, the operation fails. For example, if you specify a
     *         session duration of 12 hours, but your administrator set the maximum session duration to 6 hours, your
     *         operation fails. To learn how to view the maximum value for your role, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session"
     *         >View the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.</p>
     *         <p>
     *         By default, the value is set to 3600 seconds.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you
     *         might request using the returned credentials. The request to the federation endpoint for a console
     *         sign-in token takes a <code>SessionDuration</code> parameter that specifies the maximum length of the
     *         console session. For more information, see <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
     *         >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * A unique identifier that is used by third parties when assuming roles in their customers' accounts. For each role
     * that the third party can assume, they should instruct their customers to ensure the role's trust policy checks
     * for the external ID that the third party generated. Each time the third party assumes the role, they should pass
     * the customer's external ID. The external ID is useful in order to help third parties bind a role to the customer
     * who created it. For more information about the external ID, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to Use an
     * External ID When Granting Access to Your AWS Resources to a Third Party</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
     * =,.@:/-
     * </p>
     * 
     * @return A unique identifier that is used by third parties when assuming roles in their customers' accounts. For
     *         each role that the third party can assume, they should instruct their customers to ensure the role's
     *         trust policy checks for the external ID that the third party generated. Each time the third party assumes
     *         the role, they should pass the customer's external ID. The external ID is useful in order to help third
     *         parties bind a role to the customer who created it. For more information about the external ID, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to
     *         Use an External ID When Granting Access to Your AWS Resources to a Third Party</a> in the <i>IAM User
     *         Guide</i>.</p>
     *         <p>
     *         The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@:/-
     */
    public String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The identification number of the MFA device that is associated with the user who is making the
     * <code>AssumeRole</code> call. Specify this value if the trust policy of the role being assumed includes a
     * condition that requires MFA authentication. The value is either the serial number for a hardware device (such as
     * <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
     * <code>arn:aws:iam::123456789012:mfa/user</code>).
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     * </p>
     * 
     * @return The identification number of the MFA device that is associated with the user who is making the
     *         <code>AssumeRole</code> call. Specify this value if the trust policy of the role being assumed includes a
     *         condition that requires MFA authentication. The value is either the serial number for a hardware device
     *         (such as <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
     *         <code>arn:aws:iam::123456789012:mfa/user</code>).</p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@-
     */
    public String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The value provided by the MFA device, if the trust policy of the role being assumed requires MFA (that is, if the
     * policy includes a condition that tests for MFA). If the role being assumed requires MFA and if the
     * <code>TokenCode</code> value is missing or expired, the <code>AssumeRole</code> call returns an "access denied"
     * error.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
     * </p>
     * 
     * @return The value provided by the MFA device, if the trust policy of the role being assumed requires MFA (that
     *         is, if the policy includes a condition that tests for MFA). If the role being assumed requires MFA and if
     *         the <code>TokenCode</code> value is missing or expired, the <code>AssumeRole</code> call returns an
     *         "access denied" error.</p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
     */
    public String tokenCode() {
        return tokenCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(tokenCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleRequest)) {
            return false;
        }
        AssumeRoleRequest other = (AssumeRoleRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(roleSessionName(), other.roleSessionName())
                && Objects.equals(policy(), other.policy()) && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(externalId(), other.externalId()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(tokenCode(), other.tokenCode());
    }

    @Override
    public String toString() {
        return ToString.builder("AssumeRoleRequest").add("RoleArn", roleArn()).add("RoleSessionName", roleSessionName())
                .add("Policy", policy()).add("DurationSeconds", durationSeconds()).add("ExternalId", externalId())
                .add("SerialNumber", serialNumber()).add("TokenCode", tokenCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "RoleSessionName":
            return Optional.ofNullable(clazz.cast(roleSessionName()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "TokenCode":
            return Optional.ofNullable(clazz.cast(tokenCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends StsRequest.Builder, CopyableBuilder<Builder, AssumeRoleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role to assume.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role to assume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An identifier for the assumed role session.
         * </p>
         * <p>
         * Use the role session name to uniquely identify a session when the same role is assumed by different
         * principals or for different reasons. In cross-account scenarios, the role session name is visible to, and can
         * be logged by the account that owns the role. The role session name is also used in the ARN of the assumed
         * role principal. This means that subsequent cross-account API requests using the temporary security
         * credentials will expose the role session name to the external account in their CloudTrail logs.
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@-
         * </p>
         * 
         * @param roleSessionName
         *        An identifier for the assumed role session.</p>
         *        <p>
         *        Use the role session name to uniquely identify a session when the same role is assumed by different
         *        principals or for different reasons. In cross-account scenarios, the role session name is visible to,
         *        and can be logged by the account that owns the role. The role session name is also used in the ARN of
         *        the assumed role principal. This means that subsequent cross-account API requests using the temporary
         *        security credentials will expose the role session name to the external account in their CloudTrail
         *        logs.
         *        </p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleSessionName(String roleSessionName);

        /**
         * <p>
         * An IAM policy in JSON format.
         * </p>
         * <p>
         * This parameter is optional. If you pass a policy, the temporary security credentials that are returned by the
         * operation have the permissions that are allowed by both (the intersection of) the access policy of the role
         * that is being assumed, <i>and</i> the policy that you pass. This gives you a way to further restrict the
         * permissions for the resulting temporary security credentials. You cannot use the passed policy to grant
         * permissions that are in excess of those allowed by the access policy of the role that is being assumed. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         * >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         * characters in length. The characters can be any ASCII character from the space character to the end of the
         * valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
         * packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage how
         * close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
         * </p>
         * </note>
         * 
         * @param policy
         *        An IAM policy in JSON format.</p>
         *        <p>
         *        This parameter is optional. If you pass a policy, the temporary security credentials that are returned
         *        by the operation have the permissions that are allowed by both (the intersection of) the access policy
         *        of the role that is being assumed, <i>and</i> the policy that you pass. This gives you a way to
         *        further restrict the permissions for the resulting temporary security credentials. You cannot use the
         *        passed policy to grant permissions that are in excess of those allowed by the access policy of the
         *        role that is being assumed. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         *        >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         *        characters in length. The characters can be any ASCII character from the space character to the end of
         *        the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage
         *        return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it
         *        into a packed binary format with a separate limit. The PackedPolicySize response element indicates by
         *        percentage how close to the upper size limit the policy is, with 100% equaling the maximum allowed
         *        size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to the
         * maximum session duration setting for the role. This setting can have a value from 1 hour to 12 hours. If you
         * specify a value higher than this setting, the operation fails. For example, if you specify a session duration
         * of 12 hours, but your administrator set the maximum session duration to 6 hours, your operation fails. To
         * learn how to view the maximum value for your role, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session"
         * >View the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * By default, the value is set to 3600 seconds.
         * </p>
         * <note>
         * <p>
         * The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you might
         * request using the returned credentials. The request to the federation endpoint for a console sign-in token
         * takes a <code>SessionDuration</code> parameter that specifies the maximum length of the console session. For
         * more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         * >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param durationSeconds
         *        The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to
         *        the maximum session duration setting for the role. This setting can have a value from 1 hour to 12
         *        hours. If you specify a value higher than this setting, the operation fails. For example, if you
         *        specify a session duration of 12 hours, but your administrator set the maximum session duration to 6
         *        hours, your operation fails. To learn how to view the maximum value for your role, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session"
         *        >View the Maximum Session Duration Setting for a Role</a> in the <i>IAM User Guide</i>.</p>
         *        <p>
         *        By default, the value is set to 3600 seconds.
         *        </p>
         *        <note>
         *        <p>
         *        The <code>DurationSeconds</code> parameter is separate from the duration of a console session that you
         *        might request using the returned credentials. The request to the federation endpoint for a console
         *        sign-in token takes a <code>SessionDuration</code> parameter that specifies the maximum length of the
         *        console session. For more information, see <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html"
         *        >Creating a URL that Enables Federated Users to Access the AWS Management Console</a> in the <i>IAM
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * A unique identifier that is used by third parties when assuming roles in their customers' accounts. For each
         * role that the third party can assume, they should instruct their customers to ensure the role's trust policy
         * checks for the external ID that the third party generated. Each time the third party assumes the role, they
         * should pass the customer's external ID. The external ID is useful in order to help third parties bind a role
         * to the customer who created it. For more information about the external ID, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to Use an
         * External ID When Granting Access to Your AWS Resources to a Third Party</a> in the <i>IAM User Guide</i>.
         * </p>
         * <p>
         * The regex used to validated this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@:/-
         * </p>
         * 
         * @param externalId
         *        A unique identifier that is used by third parties when assuming roles in their customers' accounts.
         *        For each role that the third party can assume, they should instruct their customers to ensure the
         *        role's trust policy checks for the external ID that the third party generated. Each time the third
         *        party assumes the role, they should pass the customer's external ID. The external ID is useful in
         *        order to help third parties bind a role to the customer who created it. For more information about the
         *        external ID, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html">How to
         *        Use an External ID When Granting Access to Your AWS Resources to a Third Party</a> in the <i>IAM User
         *        Guide</i>.</p>
         *        <p>
         *        The regex used to validated this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@:/-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The identification number of the MFA device that is associated with the user who is making the
         * <code>AssumeRole</code> call. Specify this value if the trust policy of the role being assumed includes a
         * condition that requires MFA authentication. The value is either the serial number for a hardware device (such
         * as <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual device (such as
         * <code>arn:aws:iam::123456789012:mfa/user</code>).
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@-
         * </p>
         * 
         * @param serialNumber
         *        The identification number of the MFA device that is associated with the user who is making the
         *        <code>AssumeRole</code> call. Specify this value if the trust policy of the role being assumed
         *        includes a condition that requires MFA authentication. The value is either the serial number for a
         *        hardware device (such as <code>GAHT12345678</code>) or an Amazon Resource Name (ARN) for a virtual
         *        device (such as <code>arn:aws:iam::123456789012:mfa/user</code>).</p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of upper- and
         *        lower-case alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The value provided by the MFA device, if the trust policy of the role being assumed requires MFA (that is, if
         * the policy includes a condition that tests for MFA). If the role being assumed requires MFA and if the
         * <code>TokenCode</code> value is missing or expired, the <code>AssumeRole</code> call returns an
         * "access denied" error.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
         * </p>
         * 
         * @param tokenCode
         *        The value provided by the MFA device, if the trust policy of the role being assumed requires MFA (that
         *        is, if the policy includes a condition that tests for MFA). If the role being assumed requires MFA and
         *        if the <code>TokenCode</code> value is missing or expired, the <code>AssumeRole</code> call returns an
         *        "access denied" error.</p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenCode(String tokenCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StsRequest.BuilderImpl implements Builder {
        private String roleArn;

        private String roleSessionName;

        private String policy;

        private Integer durationSeconds;

        private String externalId;

        private String serialNumber;

        private String tokenCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleRequest model) {
            super(model);
            roleArn(model.roleArn);
            roleSessionName(model.roleSessionName);
            policy(model.policy);
            durationSeconds(model.durationSeconds);
            externalId(model.externalId);
            serialNumber(model.serialNumber);
            tokenCode(model.tokenCode);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getRoleSessionName() {
            return roleSessionName;
        }

        @Override
        public final Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public final void setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final String getTokenCode() {
            return tokenCode;
        }

        @Override
        public final Builder tokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
            return this;
        }

        public final void setTokenCode(String tokenCode) {
            this.tokenCode = tokenCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeRoleRequest build() {
            return new AssumeRoleRequest(this);
        }
    }
}
