/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifiers for the temporary security credentials that the operation returns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumedRoleUser implements ToCopyableBuilder<AssumedRoleUser.Builder, AssumedRoleUser> {
    private final String assumedRoleId;

    private final String arn;

    private AssumedRoleUser(BuilderImpl builder) {
        this.assumedRoleId = builder.assumedRoleId;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * A unique identifier that contains the role ID and the role session name of the role that is being assumed. The
     * role ID is generated by AWS when the role is created.
     * </p>
     * 
     * @return A unique identifier that contains the role ID and the role session name of the role that is being
     *         assumed. The role ID is generated by AWS when the role is created.
     */
    public String assumedRoleId() {
        return assumedRoleId;
    }

    /**
     * <p>
     * The ARN of the temporary security credentials that are returned from the <a>AssumeRole</a> action. For more
     * information about ARNs and how to use them in policies, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in <i>Using
     * IAM</i>.
     * </p>
     * 
     * @return The ARN of the temporary security credentials that are returned from the <a>AssumeRole</a> action. For
     *         more information about ARNs and how to use them in policies, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in
     *         <i>Using IAM</i>.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assumedRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumedRoleUser)) {
            return false;
        }
        AssumedRoleUser other = (AssumedRoleUser) obj;
        return Objects.equals(assumedRoleId(), other.assumedRoleId()) && Objects.equals(arn(), other.arn());
    }

    @Override
    public String toString() {
        return ToString.builder("AssumedRoleUser").add("AssumedRoleId", assumedRoleId()).add("Arn", arn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssumedRoleId":
            return Optional.ofNullable(clazz.cast(assumedRoleId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AssumedRoleUser> {
        /**
         * <p>
         * A unique identifier that contains the role ID and the role session name of the role that is being assumed.
         * The role ID is generated by AWS when the role is created.
         * </p>
         * 
         * @param assumedRoleId
         *        A unique identifier that contains the role ID and the role session name of the role that is being
         *        assumed. The role ID is generated by AWS when the role is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRoleId(String assumedRoleId);

        /**
         * <p>
         * The ARN of the temporary security credentials that are returned from the <a>AssumeRole</a> action. For more
         * information about ARNs and how to use them in policies, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in
         * <i>Using IAM</i>.
         * </p>
         * 
         * @param arn
         *        The ARN of the temporary security credentials that are returned from the <a>AssumeRole</a> action. For
         *        more information about ARNs and how to use them in policies, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a>
         *        in <i>Using IAM</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String assumedRoleId;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumedRoleUser model) {
            assumedRoleId(model.assumedRoleId);
            arn(model.arn);
        }

        public final String getAssumedRoleId() {
            return assumedRoleId;
        }

        @Override
        public final Builder assumedRoleId(String assumedRoleId) {
            this.assumedRoleId = assumedRoleId;
            return this;
        }

        public final void setAssumedRoleId(String assumedRoleId) {
            this.assumedRoleId = assumedRoleId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public AssumedRoleUser build() {
            return new AssumedRoleUser(this);
        }
    }
}
