/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.sts.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * AssumeRoleWithSamlRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssumeRoleWithSamlRequestMarshaller implements
        Marshaller<Request<AssumeRoleWithSamlRequest>, AssumeRoleWithSamlRequest> {

    public Request<AssumeRoleWithSamlRequest> marshall(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {

        if (assumeRoleWithSamlRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<AssumeRoleWithSamlRequest> request = new DefaultRequest<AssumeRoleWithSamlRequest>(assumeRoleWithSamlRequest,
                "StsClient");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (assumeRoleWithSamlRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString(assumeRoleWithSamlRequest.roleArn()));
        }

        if (assumeRoleWithSamlRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringConversion.fromString(assumeRoleWithSamlRequest.principalArn()));
        }

        if (assumeRoleWithSamlRequest.samlAssertion() != null) {
            request.addParameter("SAMLAssertion", StringConversion.fromString(assumeRoleWithSamlRequest.samlAssertion()));
        }

        if (assumeRoleWithSamlRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString(assumeRoleWithSamlRequest.policy()));
        }

        if (assumeRoleWithSamlRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger(assumeRoleWithSamlRequest.durationSeconds()));
        }

        return request;
    }

}
