/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        if (assumeRoleRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)assumeRoleRequest, "StsClient");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString((String)assumeRoleRequest.roleArn()));
        }
        if (assumeRoleRequest.roleSessionName() != null) {
            request.addParameter("RoleSessionName", StringConversion.fromString((String)assumeRoleRequest.roleSessionName()));
        }
        if (assumeRoleRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString((String)assumeRoleRequest.policy()));
        }
        if (assumeRoleRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringConversion.fromInteger((Integer)assumeRoleRequest.durationSeconds()));
        }
        if (assumeRoleRequest.externalId() != null) {
            request.addParameter("ExternalId", StringConversion.fromString((String)assumeRoleRequest.externalId()));
        }
        if (assumeRoleRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringConversion.fromString((String)assumeRoleRequest.serialNumber()));
        }
        if (assumeRoleRequest.tokenCode() != null) {
            request.addParameter("TokenCode", StringConversion.fromString((String)assumeRoleRequest.tokenCode()));
        }
        return request;
    }
}

