/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AssumeRoleWithSAMLRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AssumeRoleWithSAMLRequest.Builder, AssumeRoleWithSAMLRequest> {
    private final String roleArn;

    private final String principalArn;

    private final String samlAssertion;

    private final String policy;

    private final Integer durationSeconds;

    private AssumeRoleWithSAMLRequest(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.principalArn = builder.principalArn;
        this.samlAssertion = builder.samlAssertion;
        this.policy = builder.policy;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that the caller is assuming.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that the caller is assuming.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     */
    public String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The base-64 encoded SAML authentication response provided by the IdP.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a Relying
     * Party and Adding Claims</a> in the <i>Using IAM</i> guide.
     * </p>
     * 
     * @return The base-64 encoded SAML authentication response provided by the IdP.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a
     *         Relying Party and Adding Claims</a> in the <i>Using IAM</i> guide.
     */
    public String samlAssertion() {
        return samlAssertion;
    }

    /**
     * <p>
     * An IAM policy in JSON format.
     * </p>
     * <p>
     * The policy parameter is optional. If you pass a policy, the temporary security credentials that are returned by
     * the operation have the permissions that are allowed by both the access policy of the role that is being assumed,
     * <i> <b>and</b> </i> the policy that you pass. This gives you a way to further restrict the permissions for the
     * resulting temporary security credentials. You cannot use the passed policy to grant permissions that are in
     * excess of those allowed by the access policy of the role that is being assumed. For more information, <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
     * >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048 characters
     * in length. The characters can be any ASCII character from the space character to the end of the valid character
     * list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( ) characters.
     * </p>
     * <note>
     * <p>
     * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a packed
     * binary format with a separate limit. The PackedPolicySize response element indicates by percentage how close to
     * the upper size limit the policy is, with 100% equaling the maximum allowed size.
     * </p>
     * </note>
     * 
     * @return An IAM policy in JSON format.</p>
     *         <p>
     *         The policy parameter is optional. If you pass a policy, the temporary security credentials that are
     *         returned by the operation have the permissions that are allowed by both the access policy of the role
     *         that is being assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further
     *         restrict the permissions for the resulting temporary security credentials. You cannot use the passed
     *         policy to grant permissions that are in excess of those allowed by the access policy of the role that is
     *         being assumed. For more information, <a href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
     *         >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
     *         Guide</i>.
     *         </p>
     *         <p>
     *         The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
     *         characters in length. The characters can be any ASCII character from the space character to the end of
     *         the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return (
     *         ) characters.
     *         </p>
     *         <note>
     *         <p>
     *         The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
     *         packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage
     *         how close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
     *         </p>
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600 seconds
     * (1 hour). By default, the value is set to 3600 seconds. An expiration can also be specified in the SAML
     * authentication response's <code>SessionNotOnOrAfter</code> value. The actual expiration time is whichever value
     * is shorter.
     * </p>
     * <note>
     * <p>
     * This is separate from the duration of a console session that you might request using the returned credentials.
     * The request to the federation endpoint for a console sign-in token takes a <code>SessionDuration</code> parameter
     * that specifies the maximum length of the console session, separately from the <code>DurationSeconds</code>
     * parameter on this API. For more information, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 Federated Users to Access the AWS Management Console</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600
     *         seconds (1 hour). By default, the value is set to 3600 seconds. An expiration can also be specified in
     *         the SAML authentication response's <code>SessionNotOnOrAfter</code> value. The actual expiration time is
     *         whichever value is shorter. </p> <note>
     *         <p>
     *         This is separate from the duration of a console session that you might request using the returned
     *         credentials. The request to the federation endpoint for a console sign-in token takes a
     *         <code>SessionDuration</code> parameter that specifies the maximum length of the console session,
     *         separately from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling
     *         SAML 2.0 Federated Users to Access the AWS Management Console</a> in the <i>IAM User Guide</i>.
     *         </p>
     */
    public Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((principalArn() == null) ? 0 : principalArn().hashCode());
        hashCode = 31 * hashCode + ((samlAssertion() == null) ? 0 : samlAssertion().hashCode());
        hashCode = 31 * hashCode + ((policy() == null) ? 0 : policy().hashCode());
        hashCode = 31 * hashCode + ((durationSeconds() == null) ? 0 : durationSeconds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithSAMLRequest)) {
            return false;
        }
        AssumeRoleWithSAMLRequest other = (AssumeRoleWithSAMLRequest) obj;
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.principalArn() == null ^ this.principalArn() == null) {
            return false;
        }
        if (other.principalArn() != null && !other.principalArn().equals(this.principalArn())) {
            return false;
        }
        if (other.samlAssertion() == null ^ this.samlAssertion() == null) {
            return false;
        }
        if (other.samlAssertion() != null && !other.samlAssertion().equals(this.samlAssertion())) {
            return false;
        }
        if (other.policy() == null ^ this.policy() == null) {
            return false;
        }
        if (other.policy() != null && !other.policy().equals(this.policy())) {
            return false;
        }
        if (other.durationSeconds() == null ^ this.durationSeconds() == null) {
            return false;
        }
        if (other.durationSeconds() != null && !other.durationSeconds().equals(this.durationSeconds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (principalArn() != null) {
            sb.append("PrincipalArn: ").append(principalArn()).append(",");
        }
        if (samlAssertion() != null) {
            sb.append("SAMLAssertion: ").append(samlAssertion()).append(",");
        }
        if (policy() != null) {
            sb.append("Policy: ").append(policy()).append(",");
        }
        if (durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(durationSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AssumeRoleWithSAMLRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that the caller is assuming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The base-64 encoded SAML authentication response provided by the IdP.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a Relying
         * Party and Adding Claims</a> in the <i>Using IAM</i> guide.
         * </p>
         * 
         * @param samlAssertion
         *        The base-64 encoded SAML authentication response provided by the IdP.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html">Configuring a
         *        Relying Party and Adding Claims</a> in the <i>Using IAM</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlAssertion(String samlAssertion);

        /**
         * <p>
         * An IAM policy in JSON format.
         * </p>
         * <p>
         * The policy parameter is optional. If you pass a policy, the temporary security credentials that are returned
         * by the operation have the permissions that are allowed by both the access policy of the role that is being
         * assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further restrict the
         * permissions for the resulting temporary security credentials. You cannot use the passed policy to grant
         * permissions that are in excess of those allowed by the access policy of the role that is being assumed. For
         * more information, <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         * >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
         * Guide</i>.
         * </p>
         * <p>
         * The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         * characters in length. The characters can be any ASCII character from the space character to the end of the
         * valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage return ( )
         * characters.
         * </p>
         * <note>
         * <p>
         * The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it into a
         * packed binary format with a separate limit. The PackedPolicySize response element indicates by percentage how
         * close to the upper size limit the policy is, with 100% equaling the maximum allowed size.
         * </p>
         * </note>
         * 
         * @param policy
         *        An IAM policy in JSON format.</p>
         *        <p>
         *        The policy parameter is optional. If you pass a policy, the temporary security credentials that are
         *        returned by the operation have the permissions that are allowed by both the access policy of the role
         *        that is being assumed, <i> <b>and</b> </i> the policy that you pass. This gives you a way to further
         *        restrict the permissions for the resulting temporary security credentials. You cannot use the passed
         *        policy to grant permissions that are in excess of those allowed by the access policy of the role that
         *        is being assumed. For more information, <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html"
         *        >Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity</a> in the <i>IAM User
         *        Guide</i>.
         *        </p>
         *        <p>
         *        The format for this parameter, as described by its regex pattern, is a string of characters up to 2048
         *        characters in length. The characters can be any ASCII character from the space character to the end of
         *        the valid character list ( -\u00FF). It can also include the tab ( ), linefeed ( ), and carriage
         *        return ( ) characters.
         *        </p>
         *        <note>
         *        <p>
         *        The policy plain text must be 2048 bytes or shorter. However, an internal conversion compresses it
         *        into a packed binary format with a separate limit. The PackedPolicySize response element indicates by
         *        percentage how close to the upper size limit the policy is, with 100% equaling the maximum allowed
         *        size.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to 3600
         * seconds (1 hour). By default, the value is set to 3600 seconds. An expiration can also be specified in the
         * SAML authentication response's <code>SessionNotOnOrAfter</code> value. The actual expiration time is
         * whichever value is shorter.
         * </p>
         * <note>
         * <p>
         * This is separate from the duration of a console session that you might request using the returned
         * credentials. The request to the federation endpoint for a console sign-in token takes a
         * <code>SessionDuration</code> parameter that specifies the maximum length of the console session, separately
         * from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling
         * SAML 2.0 Federated Users to Access the AWS Management Console</a> in the <i>IAM User Guide</i>.
         * </p>
         * </note>
         * 
         * @param durationSeconds
         *        The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) to
         *        3600 seconds (1 hour). By default, the value is set to 3600 seconds. An expiration can also be
         *        specified in the SAML authentication response's <code>SessionNotOnOrAfter</code> value. The actual
         *        expiration time is whichever value is shorter. </p> <note>
         *        <p>
         *        This is separate from the duration of a console session that you might request using the returned
         *        credentials. The request to the federation endpoint for a console sign-in token takes a
         *        <code>SessionDuration</code> parameter that specifies the maximum length of the console session,
         *        separately from the <code>DurationSeconds</code> parameter on this API. For more information, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">
         *        Enabling SAML 2.0 Federated Users to Access the AWS Management Console</a> in the <i>IAM User
         *        Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);
    }

    private static final class BuilderImpl implements Builder {
        private String roleArn;

        private String principalArn;

        private String samlAssertion;

        private String policy;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithSAMLRequest model) {
            setRoleArn(model.roleArn);
            setPrincipalArn(model.principalArn);
            setSAMLAssertion(model.samlAssertion);
            setPolicy(model.policy);
            setDurationSeconds(model.durationSeconds);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getSAMLAssertion() {
            return samlAssertion;
        }

        @Override
        public final Builder samlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
            return this;
        }

        public final void setSAMLAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public AssumeRoleWithSAMLRequest build() {
            return new AssumeRoleWithSAMLRequest(this);
        }
    }
}
