/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sts.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetCallerIdentity</a> request, including information about the entity making
 * the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCallerIdentityResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetCallerIdentityResponse.Builder, GetCallerIdentityResponse> {
    private final String userId;

    private final String account;

    private final String arn;

    private GetCallerIdentityResponse(BuilderImpl builder) {
        this.userId = builder.userId;
        this.account = builder.account;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The unique identifier of the calling entity. The exact value depends on the type of entity making the call. The
     * values returned are those listed in the <b>aws:userid</b> column in the <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable">Principal
     * table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The unique identifier of the calling entity. The exact value depends on the type of entity making the
     *         call. The values returned are those listed in the <b>aws:userid</b> column in the <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable"
     *         >Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The AWS account ID number of the account that owns or contains the calling entity.
     * </p>
     * 
     * @return The AWS account ID number of the account that owns or contains the calling entity.
     */
    public String account() {
        return account;
    }

    /**
     * <p>
     * The AWS ARN associated with the calling entity.
     * </p>
     * 
     * @return The AWS ARN associated with the calling entity.
     */
    public String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((userId() == null) ? 0 : userId().hashCode());
        hashCode = 31 * hashCode + ((account() == null) ? 0 : account().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCallerIdentityResponse)) {
            return false;
        }
        GetCallerIdentityResponse other = (GetCallerIdentityResponse) obj;
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.account() == null ^ this.account() == null) {
            return false;
        }
        if (other.account() != null && !other.account().equals(this.account())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (userId() != null) {
            sb.append("UserId: ").append(userId()).append(",");
        }
        if (account() != null) {
            sb.append("Account: ").append(account()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetCallerIdentityResponse> {
        /**
         * <p>
         * The unique identifier of the calling entity. The exact value depends on the type of entity making the call.
         * The values returned are those listed in the <b>aws:userid</b> column in the <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable"
         * >Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param userId
         *        The unique identifier of the calling entity. The exact value depends on the type of entity making the
         *        call. The values returned are those listed in the <b>aws:userid</b> column in the <a href=
         *        "http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable"
         *        >Principal table</a> found on the <b>Policy Variables</b> reference page in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The AWS account ID number of the account that owns or contains the calling entity.
         * </p>
         * 
         * @param account
         *        The AWS account ID number of the account that owns or contains the calling entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The AWS ARN associated with the calling entity.
         * </p>
         * 
         * @param arn
         *        The AWS ARN associated with the calling entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    private static final class BuilderImpl implements Builder {
        private String userId;

        private String account;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCallerIdentityResponse model) {
            setUserId(model.userId);
            setAccount(model.account);
            setArn(model.arn);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getAccount() {
            return account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public GetCallerIdentityResponse build() {
            return new GetCallerIdentityResponse(this);
        }
    }
}
