/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.sts.DefaultSTSClientBuilder;
import software.amazon.awssdk.services.sts.STSClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IDPCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IDPRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.STSException;

public interface STSClient
extends AutoCloseable {
    public static final String SERVICE_NAME = "sts";

    public static STSClient create() {
        return (STSClient)STSClient.builder().build();
    }

    public static STSClientBuilder builder() {
        return new DefaultSTSClientBuilder();
    }

    default public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleWithSAMLResponse assumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IDPRejectedClaimException, IDPCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetCallerIdentityResponse getCallerIdentity() throws SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetSessionTokenResponse getSessionToken() throws RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    default public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, SdkBaseException, SdkClientException, STSException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

