/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.services.sts.STSClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
public class StsGetFederationTokenCredentialsProvider
extends StsCredentialsProvider {
    private final GetFederationTokenRequest getFederationTokenRequest;

    private StsGetFederationTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-federation-token-credentials-provider");
        Validate.notNull((Object)((Object)builder.getFederationTokenRequest), (String)"Get session token request must not be null.", (Object[])new Object[0]);
        this.getFederationTokenRequest = builder.getFederationTokenRequest;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(STSClient stsClient) {
        return stsClient.getFederationToken(this.getFederationTokenRequest).credentials();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetFederationTokenCredentialsProvider> {
        private GetFederationTokenRequest getFederationTokenRequest;

        private Builder() {
            super((B x$0) -> new StsGetFederationTokenCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(GetFederationTokenRequest getFederationTokenRequest) {
            this.getFederationTokenRequest = getFederationTokenRequest;
            return this;
        }
    }
}

